/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.gui.screens.inventory.ModAnvilScreen;
import fuzs.easyanvils.client.handler.BlockStateTranslator;
import fuzs.easyanvils.client.handler.NameTagTooltipHandler;
import fuzs.easyanvils.client.renderer.blockentity.AnvilRenderer;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.event.v1.ClientStartedCallback;
import fuzs.puzzleslib.api.client.event.v1.gui.ItemTooltipCallback;
import fuzs.puzzleslib.api.client.util.v1.ModelLoadingHelper;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.UnbakedBlockStateModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EasyAnvilsClient
implements ClientModConstructor {
    public void onConstructMod() {
        EasyAnvilsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ClientStartedCallback.EVENT.register(minecraft -> {
            for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
                RenderType renderType = ClientAbstractions.INSTANCE.getRenderType((Block)entry.getKey());
                ClientAbstractions.INSTANCE.registerRenderType((Block)entry.getValue(), renderType);
            }
        });
        ItemTooltipCallback.EVENT.register(NameTagTooltipHandler::onItemTooltip);
    }

    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((ResourceManager)resourceManager, (Block)oldBlock, (Executor)executor), (loadedModels, consumer) -> {
            Map<ModelResourceLocation, ModelResourceLocation> modelResourceLocations = BlockStateTranslator.INSTANCE.convertAllBlockStates((Block)newBlock, (Block)oldBlock);
            for (BlockState blockState : newBlock.getStateDefinition().getPossibleStates()) {
                BlockStateModelLoader.LoadedModel loadedModel;
                ModelResourceLocation newModelResourceLocation = BlockModelShaper.stateToModelLocation((BlockState)blockState);
                ModelResourceLocation oldModelResourceLocation = modelResourceLocations.get(newModelResourceLocation);
                UnbakedBlockStateModel model = null;
                if (oldModelResourceLocation != null && (loadedModel = (BlockStateModelLoader.LoadedModel)loadedModels.models().get(oldModelResourceLocation)) != null) {
                    model = loadedModel.model();
                }
                if (model != null) {
                    consumer.accept(blockState, model);
                    continue;
                }
                EasyAnvils.LOGGER.warn("Missing model for variant: '{}'", (Object)newModelResourceLocation);
                consumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.ANVIL_MENU_TYPE.value(), ModAnvilScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.value(), AnvilRenderer::new);
    }
}

