/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.gui.components.FormattableEditBox;
import fuzs.easyanvils.client.gui.components.FormattingGuideWidget;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.network.client.C2SNameTagUpdateMessage;
import fuzs.easyanvils.util.ComponentDecomposer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NameTagEditScreen
extends Screen {
    public static final String KEY_NAME_TAG_EDIT = "easyanvils.name_tag.edit";
    private static final ResourceLocation EDIT_NAME_TAG_LOCATION = EasyAnvils.id("textures/gui/edit_name_tag.png");
    private final int imageWidth = 176;
    private final int imageHeight = 48;
    private int leftPos;
    private int topPos;
    private final int titleLabelX = 60;
    private final int titleLabelY = 8;
    private final InteractionHand hand;
    private String itemName;
    private EditBox name;

    public NameTagEditScreen(InteractionHand hand, Component title) {
        super((Component)Component.translatable((String)KEY_NAME_TAG_EDIT, (Object[])new Object[]{Items.NAME_TAG.getName()}));
        this.hand = hand;
        this.itemName = ComponentDecomposer.toFormattedString(title);
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = this.height / 4;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            EasyAnvils.NETWORK.sendMessage(new C2SNameTagUpdateMessage(this.hand, this.itemName).toServerboundMessage());
            this.onClose();
        }).bounds(this.width / 2 - 100, this.height / 4 + 120, 200, 20).build());
        this.name = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.renamingSupportsFormatting ? new FormattableEditBox(this.font, this.leftPos + 62, this.topPos + 26, 103, 12, (Component)Component.translatable((String)"container.repair")) : new EditBox(this.font, this.leftPos + 62, this.topPos + 26, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(s -> {
            this.itemName = s;
        });
        this.name.setValue(this.itemName);
        this.addWidget((GuiEventListener)this.name);
        this.setInitialFocus((GuiEventListener)this.name);
        this.addRenderableWidget((GuiEventListener)new FormattingGuideWidget(this.leftPos + this.imageWidth - 7, this.topPos + this.titleLabelY, this.font));
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.name.getValue();
        this.init(minecraft, width, height);
        this.name.setValue(s);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040, false);
        this.name.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(RenderType::guiTextured, EDIT_NAME_TAG_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
        guiGraphics.renderItem(new ItemStack((ItemLike)Items.NAME_TAG), (this.leftPos + 17) / 2, (this.topPos + 8) / 2);
        guiGraphics.pose().popPose();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

