/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockStateTranslator {
    public static final BlockStateTranslator INSTANCE = new BlockStateTranslator();

    public Map<ModelResourceLocation, ModelResourceLocation> convertAllBlockStates(Block oldBlock, Block newBlock) {
        HashMap<ModelResourceLocation, ModelResourceLocation> modelLocations = new HashMap<ModelResourceLocation, ModelResourceLocation>();
        for (BlockState oldBlockState : oldBlock.getStateDefinition().getPossibleStates()) {
            BlockState newBlockState = this.convertBlockState((StateDefinition<Block, BlockState>)newBlock.getStateDefinition(), oldBlockState);
            modelLocations.put(BlockModelShaper.stateToModelLocation((BlockState)oldBlockState), BlockModelShaper.stateToModelLocation((BlockState)newBlockState));
        }
        return modelLocations;
    }

    private BlockState convertBlockState(StateDefinition<Block, BlockState> newStateDefinition, BlockState oldBlockState) {
        BlockState newBlockState = (BlockState)newStateDefinition.any();
        for (Map.Entry entry : oldBlockState.getValues().entrySet()) {
            newBlockState = this.setBlockStateValue((Property)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.getProperty(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private <T extends Comparable<T>, V extends T> BlockState setBlockStateValue(Property<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable Property<?>> propertyGetter, BlockState blockState) {
        Property<?> newProperty = propertyGetter.apply(oldProperty.getName());
        if (newProperty != null) {
            Comparable<?> newValue = this.getNewPropertyValue(oldProperty, newProperty, oldValue);
            return (BlockState)blockState.setValue(newProperty, newValue);
        }
        return blockState;
    }

    protected Comparable<?> getNewPropertyValue(Property<?> oldProperty, Property<?> newProperty, Comparable<?> oldValue) {
        return oldValue;
    }
}

