/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.PlayerDeathEvent;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class DeathEvents {
    public DeathEvents() {
        de.maxhenkel.gravestone.corelib.death.DeathEvents.register();
    }

    @SubscribeEvent
    public void playerDeath(PlayerDeathEvent event) {
        BlockEntity tileentity;
        event.storeDeath();
        Death death = event.getDeath();
        ServerPlayer player = event.getPlayer();
        Level world = player.level();
        if (DeathEvents.keepInventory((Player)player)) {
            return;
        }
        BlockPos graveStoneLocation = GraveUtils.getGraveStoneLocation(world, death.getBlockPos());
        if (((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            player.getInventory().add(((ObituaryItem)((Object)Main.OBITUARY.get())).toStack(death));
        }
        if (graveStoneLocation == null) {
            Main.LOGGER.info("Grave of '{}' can't be placed (No space)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        world.setBlockAndUpdate(graveStoneLocation, (BlockState)((GraveStoneBlock)((Object)Main.GRAVESTONE.get())).defaultBlockState().setValue(GraveStoneBlock.FACING, (Comparable)player.getDirection().getOpposite()));
        if (GraveUtils.isReplaceable(world, graveStoneLocation.below())) {
            world.setBlockAndUpdate(graveStoneLocation.below(), Blocks.DIRT.defaultBlockState());
        }
        if (!((tileentity = world.getBlockEntity(graveStoneLocation)) instanceof GraveStoneTileEntity)) {
            Main.LOGGER.info("Grave of '{}' can't be filled with loot (No tileentity found)", (Object)death.getPlayerName());
            Main.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        GraveStoneTileEntity gravestone = (GraveStoneTileEntity)tileentity;
        gravestone.setDeath(death);
        event.removeDrops();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!((Boolean)Main.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (DeathEvents.keepInventory(event.getEntity())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().getInventory().items) {
            if (!(stack.getItem() instanceof ObituaryItem)) continue;
            event.getEntity().getInventory().add(stack);
        }
    }

    public static boolean keepInventory(Player player) {
        try {
            MinecraftServer server = player.getCommandSenderWorld().getServer();
            if (server == null) {
                return false;
            }
            return server.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
        }
        catch (Exception e) {
            return false;
        }
    }
}

