/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LeafTypeLoader
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation LEAVES_ATLAS = ResourceLocation.fromNamespaceAndPath((String)"fallingleaves", (String)"leaves");
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.json((String)"fallingleaves/leaftypes");
    private final TextureAtlas textureAtlas;
    private final Map<ResourceLocation, LeafTypeSettings> spriteSets = Maps.newHashMap();
    private Map<ResourceLocation, LeafType> leafTypes = Maps.newHashMap();

    @Nullable
    public LeafTypeSettings getSpriteSet(ResourceLocation leafType) {
        return this.spriteSets.get(leafType);
    }

    public LeafTypeLoader(TextureManager manager) {
        this.textureAtlas = new TextureAtlas(LEAVES_ATLAS);
        manager.register(this.textureAtlas.location(), (AbstractTexture)this.textureAtlas);
    }

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull Executor pBackgroundExecutor, @NotNull Executor p_10643_) {
        CompletionStage textures = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.listMatchingResources(resourceManager).entrySet(), pBackgroundExecutor).thenApplyAsync(list -> list.stream().collect(Collectors.toMap(entry -> PARTICLE_LISTER.fileToId((ResourceLocation)entry.getKey()), entry -> {
            LeafType leafType;
            block8: {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonObject object = GsonHelper.parse((Reader)reader);
                    leafType = LeafType.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst).orElseGet(LeafType::new);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new LeafType();
                    }
                }
                ((Reader)reader).close();
            }
            return leafType;
        })));
        CompletionStage preparations = SpriteLoader.create((TextureAtlas)this.textureAtlas).loadAndStitch(resourceManager, LEAVES_ATLAS, 0, pBackgroundExecutor).thenCompose(SpriteLoader.Preparations::waitForUpload);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{textures, preparations}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$5((CompletableFuture)preparations, (CompletableFuture)textures, arg_0), p_10643_);
    }

    public void close() {
        this.textureAtlas.clearTextureData();
    }

    @NotNull
    public String getName() {
        return "Leaf Type";
    }

    private /* synthetic */ void lambda$reload$5(CompletableFuture preparations, CompletableFuture textures, Void param) {
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)preparations.join();
        this.textureAtlas.upload(spriteloader$preparations);
        HashSet set = new HashSet();
        HashSet<ResourceLocation> existingSprites = new HashSet<ResourceLocation>(this.spriteSets.keySet());
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.missing();
        ((Map)textures.join()).forEach((key, leafType) -> {
            if (!leafType.textures.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourceLocation : leafType.textures) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)spriteloader$preparations.regions().get(resourceLocation);
                    if (sprite == null) {
                        set.add(resourceLocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(sprite);
                }
                LeafTypeSettings settings = this.spriteSets.get(key);
                existingSprites.remove(key);
                if (settings == null) {
                    settings = new LeafTypeSettings(new ParticleEngine.MutableSpriteSet(), (LeafType)leafType);
                    this.spriteSets.put((ResourceLocation)key, settings);
                }
                settings.spriteSet.rebind(list);
                settings.leafType = leafType;
            }
        });
        this.leafTypes = (Map)textures.join();
        existingSprites.forEach(this.spriteSets::remove);
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
    }

    public static class LeafTypeSettings
    implements ParticleProvider {
        private final ParticleEngine.MutableSpriteSet spriteSet;
        private LeafType leafType;

        public LeafTypeSettings(ParticleEngine.MutableSpriteSet spriteSet, LeafType leafType) {
            this.spriteSet = spriteSet;
            this.leafType = leafType;
        }

        public LeafType getLeafType() {
            return this.leafType;
        }

        @Override
        public ParticleEngine.MutableSpriteSet getSpriteSet() {
            return this.spriteSet;
        }

        @Override
        public float sizeModifier() {
            return this.leafType.sizeModifier();
        }

        @Override
        public float lifeSpawnModifier() {
            return this.leafType.lifeSpanModifier();
        }

        public float snowSizeModifier() {
            return this.leafType.snowSizeModifier();
        }
    }

    public record LeafType(Collection<ResourceLocation> textures, float sizeModifier, float lifeSpanModifier, float snowSizeModifier) {
        public static final Codec<LeafType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.listOf().fieldOf("textures").forGetter(l -> new ArrayList<ResourceLocation>(l.textures)), (App)Codec.FLOAT.optionalFieldOf("sizeModifier").forGetter(l -> Optional.of(Float.valueOf(l.sizeModifier))), (App)Codec.FLOAT.optionalFieldOf("lifeSpanModifier").forGetter(l -> Optional.of(Float.valueOf(l.lifeSpanModifier))), (App)Codec.FLOAT.optionalFieldOf("snowSizeModifier").forGetter(l -> Optional.of(Float.valueOf(l.lifeSpanModifier)))).apply((Applicative)inst, LeafType::new));

        public LeafType(Collection<ResourceLocation> textures, Optional<Float> sizeModifier, Optional<Float> lifeSpanModifier, Optional<Float> snowSizeModifier) {
            this(textures, sizeModifier.orElse(Float.valueOf(1.0f)).floatValue(), lifeSpanModifier.orElse(Float.valueOf(1.0f)).floatValue(), snowSizeModifier.orElse(Float.valueOf(1.0f)).floatValue());
        }

        public LeafType() {
            this(Collections.emptyList(), 1.0f, 1.0f, 1.0f);
        }
    }

    public static interface ParticleProvider {
        public ParticleEngine.MutableSpriteSet getSpriteSet();

        public float sizeModifier();

        public float lifeSpawnModifier();
    }
}

