/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.mixin;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.WeatherParticleSpawner;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.WeatherEffectRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeatherEffectRenderer.class})
public class WeatherEffectRendererMixin {
    @Unique
    private int pretty_Rain$rainSoundTime;

    @Inject(method={"tickRainParticles"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRainParticles(ClientLevel level, Camera camera, int ticks, ParticleStatus particleStatus, CallbackInfo ci) {
        if (!ParticleRainConfig.tickVanillaWeather) {
            float f = level.getRainLevel(1.0f);
            if (f > 0.0f) {
                RandomSource random = RandomSource.create((long)((long)ticks * 312987231L));
                BlockPos blockPos = BlockPos.containing((Position)camera.getPosition());
                BlockPos blockPos2 = null;
                int j = 0;
                while ((float)j < 100.0f * f * f) {
                    int l;
                    int k = random.nextInt(21) - 10;
                    BlockPos blockPos3 = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos.offset(k, 0, l = random.nextInt(21) - 10));
                    if (blockPos3.getY() > level.getMinY() && blockPos3.getY() <= blockPos.getY() + 10 && blockPos3.getY() >= blockPos.getY() - 10) {
                        blockPos2 = blockPos3.below();
                    }
                    ++j;
                }
                if (blockPos2 != null && random.nextInt(3) < this.pretty_Rain$rainSoundTime++) {
                    this.pretty_Rain$rainSoundTime = 0;
                    if (blockPos2.getY() > blockPos.getY() + 1 && level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > Mth.floor((float)blockPos.getY())) {
                        SoundEvent sound = WeatherParticleSpawner.getBiomeSound(blockPos2, true);
                        if (sound != null) {
                            level.playLocalSound(blockPos2, sound, SoundSource.WEATHER, 0.1f, 0.5f, false);
                        }
                    } else {
                        SoundEvent sound = WeatherParticleSpawner.getBiomeSound(blockPos2, false);
                        if (sound != null) {
                            level.playLocalSound(blockPos2, sound, SoundSource.WEATHER, 0.2f, 1.0f, false);
                        }
                    }
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/world/level/Level;Lnet/minecraft/client/renderer/MultiBufferSource;IFLnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(Level level, MultiBufferSource bufferSource, int ticks, float partialTick, Vec3 cameraPosition, CallbackInfo ci) {
        if (!ParticleRainConfig.renderVanillaWeather) {
            ci.cancel();
        }
    }
}

