/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;

public class DustMoteParticle
extends WeatherParticle {
    protected DustMoteParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        this.setSprite(provider.get(level.getRandom()));
        this.quadSize = ParticleRainConfig.SandOptions.moteSize;
        this.xd = ParticleRainConfig.SandOptions.windStrength;
        this.zd = ParticleRainConfig.SandOptions.windStrength;
        this.gravity = ParticleRainConfig.SandOptions.gravity;
        Color color = new Color(level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing((double)x, (double)y, (double)z)).below()).getBlock().defaultMapColor().calculateARGBColor(MapColor.Brightness.NORMAL));
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.onGround) {
            this.yd = 0.1f;
        }
        this.removeIfObstructed();
        if (!this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.shouldFadeOut = true;
            this.gravity = 0.0f;
        } else {
            this.xd = 0.2;
            this.zd = 0.2;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new DustMoteParticle(level, x, y, z, this.provider);
        }
    }
}

