/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.DustMoteParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class DustParticle
extends DustMoteParticle {
    protected DustParticle(ClientLevel clientWorld, double x, double y, double z, SpriteSet provider) {
        super(clientWorld, x, y, z, provider);
        this.quadSize = ParticleRainConfig.SandOptions.size;
        this.gravity = ParticleRainConfig.SandOptions.gravity - 0.1f;
        if (ParticleRainConfig.SandOptions.spawnOnGround) {
            this.yd = 0.1f;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.onGround) {
            this.yd = 0.01f;
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)tickPercentage, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)tickPercentage, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)tickPercentage, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = camera.rotation();
        y = y + Mth.sin((float)(Mth.lerp((float)tickPercentage, (float)((float)this.age - 1.0f), (float)this.age) / 20.0f)) + 1.5f;
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, tickPercentage);
    }

    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new DustParticle(level, x, y, z, this.provider);
        }
    }
}

