/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.ParticleRegistry;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RainParticle
extends WeatherParticle {
    protected RainParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        if (ParticleRainConfig.biomeTint) {
            ParticleRainClient.applyWaterTint(this, level, (BlockPos)this.pos);
        }
        this.quadSize = ParticleRainConfig.RainOptions.size;
        this.gravity = ParticleRainConfig.RainOptions.gravity;
        this.yd = -this.gravity;
        this.setSprite(Minecraft.getInstance().particleEngine.textureAtlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)("rain" + this.random.nextInt(4)))));
        this.xd = level.isThundering() ? (double)(this.gravity * ParticleRainConfig.RainOptions.stormWindStrength) : (double)(this.gravity * ParticleRainConfig.RainOptions.windStrength);
        if (ParticleRainConfig.yLevelWindAdjustment) {
            this.xd *= ParticleRainClient.yLevelWindAdjustment(y);
        }
        this.zd = this.xd;
        this.lifetime = ParticleRainConfig.particleRadius * 5;
        Vec3 vec3 = Minecraft.getInstance().cameraEntity.position();
        this.roll = (float)(org.joml.Math.atan2((double)(x - vec3.x), (double)(z - vec3.z)) + 1.5707963705062866);
    }

    @Override
    public void fadeIn() {
        if (this.age < 20) {
            this.alpha = org.joml.Math.clamp((float)0.0f, (float)((float)ParticleRainConfig.RainOptions.opacity / 100.0f), (float)((float)this.age * 1.0f / 20.0f));
        }
    }

    @Override
    public void tick() {
        Vec3 raycastEnd;
        Vec3 raycastStart;
        BlockHitResult hit;
        super.tick();
        if (this.onGround || !this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            if ((ParticleRainConfig.doSplashParticles || ParticleRainConfig.doSmokeParticles || ParticleRainConfig.doRippleParticles) && Minecraft.getInstance().cameraEntity.position().distanceTo(this.pos.getCenter()) < (double)ParticleRainConfig.particleRadius - (double)ParticleRainConfig.particleRadius / 2.0) {
                for (int i = 0; i < ParticleRainConfig.RainOptions.splashDensity; ++i) {
                    Vec3 spawnPos = Vec3.atLowerCornerWithOffset((Vec3i)this.pos, (double)(this.random.nextFloat() * 3.0f - 1.0f), (double)0.0, (double)(this.random.nextFloat() * 3.0f - 1.0f));
                    double d = this.random.nextDouble();
                    double e = this.random.nextDouble();
                    BlockPos blockPos = BlockPos.containing((Position)spawnPos);
                    BlockState blockState = this.level.getBlockState(blockPos);
                    FluidState fluidState = this.level.getFluidState(blockPos);
                    VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.level, blockPos);
                    double voxelHeight = voxelShape.max(Direction.Axis.Y, d, e);
                    double fluidHeight = fluidState.getHeight((BlockGetter)this.level, blockPos);
                    double height = Math.max(voxelHeight, fluidHeight);
                    Vec3 raycastStart2 = new Vec3(this.x, this.y, this.z);
                    Vec3 raycastEnd2 = new Vec3(spawnPos.x, this.y, spawnPos.z);
                    BlockHitResult hit2 = this.level.clip(new ClipContext(raycastStart2, raycastEnd2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                    Vec2 raycastHit = new Vec2((float)hit2.getLocation().x, (float)hit2.getLocation().z);
                    if (height == 0.0) continue;
                    Vec2 vec2 = new Vec2((float)spawnPos.x, (float)spawnPos.z);
                    if (!((double)raycastHit.distanceToSqr(vec2) < 0.01)) continue;
                    if (ParticleRainConfig.doRippleParticles && fluidState.isSourceOfType((Fluid)Fluids.WATER)) {
                        if (height == 1.0) continue;
                        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleRegistry.RIPPLE.get(), spawnPos.x, spawnPos.y + height, spawnPos.z, 0.0, 0.0, 0.0);
                        if (!this.level.isThundering() || !ParticleRainConfig.doSplashParticles) continue;
                        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.RAIN, spawnPos.x, spawnPos.y + height, spawnPos.z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (ParticleRainConfig.doSmokeParticles && (blockState.is(BlockTags.INFINIBURN_OVERWORLD) || blockState.is(BlockTags.STRIDER_WARM_BLOCKS))) {
                        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.SMOKE, spawnPos.x, spawnPos.y + height, spawnPos.z, 0.0, 0.0, 0.0);
                        if (!this.level.isThundering()) continue;
                        Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, spawnPos.x, spawnPos.y + height, spawnPos.z, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!ParticleRainConfig.doSplashParticles) continue;
                    Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.RAIN, spawnPos.x, spawnPos.y + height, spawnPos.z, 0.0, 0.0, 0.0);
                }
            }
            this.remove();
        } else if (this.removeIfObstructed() && (hit = this.level.clip(new ClipContext(raycastStart = new Vec3(this.x, this.y, this.z), raycastEnd = new Vec3(this.x + (double)ParticleRainConfig.RainOptions.windStrength, this.y, this.z + (double)ParticleRainConfig.RainOptions.windStrength), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType().equals((Object)HitResult.Type.BLOCK)) {
            BlockState state;
            if (ParticleRainConfig.doStreakParticles && Minecraft.getInstance().cameraEntity.position().distanceTo(this.pos.getCenter()) < (double)ParticleRainConfig.particleRadius - (double)ParticleRainConfig.particleRadius / 2.0 && ((state = this.level.getBlockState(hit.getBlockPos())).is(BlockTags.IMPERMEABLE) || state.is(BlockTags.MINEABLE_WITH_PICKAXE))) {
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleRegistry.STREAK.get(), this.x, this.y, this.z, (double)hit.getDirection().get2DDataValue(), 0.0, 0.0);
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.RAIN, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
            this.remove();
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vector3f camPos = camera.getPosition().toVector3f();
        float x = (float)(Mth.lerp((double)tickPercentage, (double)this.xo, (double)this.x) - (double)camPos.x);
        float y = (float)(Mth.lerp((double)tickPercentage, (double)this.yo, (double)this.y) - (double)camPos.y);
        float z = (float)(Mth.lerp((double)tickPercentage, (double)this.zo, (double)this.z) - (double)camPos.z);
        Vector3f delta = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd);
        float angle = org.joml.Math.acos((float)delta.normalize().y);
        Vector3f axis = new Vector3f(-delta.z(), 0.0f, delta.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        quaternion.mul((Quaternionfc)Axis.YN.rotation(this.roll));
        quaternion = this.flipItTurnwaysIfBackfaced(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, tickPercentage);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new RainParticle(level, x, y, z);
        }
    }
}

