/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ShrubParticle
extends WeatherParticle {
    /*
     * Unable to fully structure code
     */
    protected ShrubParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.quadSize = 0.5f;
        this.gravity = ParticleRainConfig.ShrubOptions.gravity;
        this.xd = ParticleRainConfig.SandOptions.windStrength;
        this.zd = ParticleRainConfig.SandOptions.windStrength;
        if (ParticleRainConfig.SandOptions.spawnOnGround) {
            this.yd = 0.10000000149011612;
        }
        itemStack = new ItemStack((ItemLike)Items.DEAD_BUSH);
        renderState = new ItemStackRenderState();
        blockState = level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)this.pos));
        if (blockState.is(BlockTags.SWORD_EFFICIENT)) {
            if (!blockState.is(BlockTags.CROPS)) {
                itemStack = blockState.getBlock().asItem().getDefaultInstance();
                Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.NONE, false, (Level)level, null, 0);
                particleIcon = renderState.layers[0].model.getParticleIcon();
                try {
                    resourceLocation = ResourceLocation.parse((String)(particleIcon.contents().name().getNamespace() + ":models/" + particleIcon.contents().name().toString().substring(particleIcon.contents().name().getNamespace().toString().length() + 1) + ".json"));
                    resource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(resourceLocation);
                    inputStream = resource.open();
                    try {
                        string = new String(inputStream.readAllBytes());
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    if (!string.contains("tint")) ** GOTO lbl38
                    colorInt = BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)this.pos);
                    color = new Color(colorInt);
                    this.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if ((double)level.random.nextFloat() < 0.9) {
            this.remove();
        }
lbl38:
        // 6 sources

        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.NONE, false, (Level)level, null, 0);
        this.setSprite(renderState.layers[0].model.getParticleIcon());
    }

    @Override
    public void tick() {
        super.tick();
        this.removeIfObstructed();
        if (!this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.shouldFadeOut = true;
            this.gravity = 0.0f;
        } else {
            this.xd = 0.2;
            this.zd = 0.2;
        }
        this.oRoll = this.roll;
        this.roll += ParticleRainConfig.ShrubOptions.rotationAmount;
        if (this.onGround) {
            this.yd = ParticleRainConfig.ShrubOptions.bounciness;
        }
    }

    @Override
    public void fadeIn() {
        if (this.age < 10) {
            this.alpha = (float)this.age * 1.0f / 10.0f;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vector3f camPos = camera.getPosition().toVector3f();
        float x = (float)(Mth.lerp((double)tickPercentage, (double)this.xo, (double)this.x) - (double)camPos.x);
        float y = (float)(Mth.lerp((double)tickPercentage, (double)this.yo, (double)this.y) - (double)camPos.y);
        float z = (float)(Mth.lerp((double)tickPercentage, (double)this.zo, (double)this.z) - (double)camPos.z);
        float angle = (float)Math.atan2((double)this.xd, (double)this.zd);
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(angle);
        Quaternionf quat1 = new Quaternionf(new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
        Quaternionf quat2 = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
        quat1.mul((Quaternionfc)quaternion).rotateX(Mth.lerp((float)tickPercentage, (float)this.oRoll, (float)this.roll));
        quat2.mul((Quaternionfc)quaternion).rotateZ(Mth.lerp((float)tickPercentage, (float)this.oRoll, (float)this.roll));
        quat1 = this.flipItTurnwaysIfBackfaced(quat1, new Vector3f(x, y, z));
        quat2 = this.flipItTurnwaysIfBackfaced(quat2, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quat1, x, y, z, tickPercentage);
        this.renderRotatedQuad(vertexConsumer, quat2, x, y, z, tickPercentage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

