/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SnowParticle
extends WeatherParticle {
    float rotationAmount;

    protected SnowParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.quadSize = ParticleRainConfig.SnowOptions.size;
        this.gravity = ParticleRainConfig.SnowOptions.gravity;
        this.yd = -this.gravity;
        this.setSprite(Minecraft.getInstance().particleEngine.textureAtlas.getSprite(ResourceLocation.fromNamespaceAndPath((String)"particlerain", (String)("snow" + this.random.nextInt(4)))));
        this.xd = level.isThundering() ? (double)(this.gravity * ParticleRainConfig.SnowOptions.stormWindStrength) : (double)(this.gravity * ParticleRainConfig.SnowOptions.windStrength);
        if (ParticleRainConfig.yLevelWindAdjustment) {
            this.xd *= ParticleRainClient.yLevelWindAdjustment(y);
        }
        this.zd = this.xd;
        this.rotationAmount = level.getRandom().nextBoolean() ? 1.0f : -1.0f;
    }

    @Override
    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll = this.oRoll + (this.level.isThundering() ? ParticleRainConfig.SnowOptions.stormRotationAmount : ParticleRainConfig.SnowOptions.rotationAmount) * this.rotationAmount;
        if (this.onGround || this.removeIfObstructed()) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SnowParticle(level, x, y, z);
        }
    }
}

