/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class StreakParticle
extends WeatherParticle {
    Direction direction;

    private StreakParticle(ClientLevel level, double x, double y, double z, int direction2D, SpriteSet provider) {
        super(level, x, y, z);
        if (ParticleRainConfig.biomeTint) {
            ParticleRainClient.applyWaterTint(this, level, (BlockPos)this.pos);
        } else {
            this.setColor(0.2f, 0.3f, 1.0f);
        }
        this.setSprite(provider.get(level.getRandom()));
        this.quadSize = 0.5f;
        this.gravity = this.random.nextFloat() / 10.0f;
        this.roll = (float)direction2D * 1.5707964f;
        this.direction = Direction.from2DDataValue((int)direction2D);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.age % 10 == 0) {
            this.gravity = this.random.nextBoolean() ? this.random.nextFloat() / 10.0f : 0.0f;
        }
        BlockState state = this.level.getBlockState(this.pos.relative(this.direction.getOpposite()));
        FluidState fluidState = this.level.getFluidState((BlockPos)this.pos);
        if (!(this.shouldFadeOut || !this.onGround && (state.is(BlockTags.IMPERMEABLE) || state.is(BlockTags.MINEABLE_WITH_PICKAXE)) && fluidState.isEmpty())) {
            if (state.isAir()) {
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, this.x, this.y - 0.25, this.z, 0.0, 0.0, 0.0);
            }
            this.gravity = 0.0f;
            this.yd = 0.0;
            this.shouldFadeOut = true;
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternion = new Quaternionf(new AxisAngle4d((double)this.roll, 0.0, 1.0, 0.0));
        this.flipItTurnwaysIfBackfaced(quaternion, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y + 0.25f, z, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new StreakParticle(level, x, y, z, (int)velocityX, this.provider);
        }
    }
}

