/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    boolean shouldFadeOut = false;
    float temperature;

    protected WeatherParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSize(0.01f, 0.01f);
        this.lifetime = ParticleRainConfig.particleRadius * 10;
        this.alpha = 0.0f;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.temperature = ((Biome)level.getBiome((BlockPos)this.pos).value()).getBaseTemperature();
        ++ParticleRainClient.particleCount;
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y - 0.2, this.z);
        this.removeIfOOB();
        if (this.shouldFadeOut) {
            this.fadeOut();
        } else if (this.age % 10 == 0) {
            if ((double)Mth.abs((float)(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getBaseTemperature() - this.temperature)) > 0.4) {
                this.shouldFadeOut = true;
            }
        } else {
            this.fadeIn();
        }
    }

    public void fadeIn() {
        if (this.age < 20) {
            this.alpha = (float)this.age * 1.0f / 20.0f;
        }
    }

    public void fadeOut() {
        if ((double)this.alpha < 0.01) {
            this.remove();
        } else {
            this.alpha -= 0.05f;
        }
    }

    public void remove() {
        if (this.isAlive()) {
            --ParticleRainClient.particleCount;
        }
        super.remove();
    }

    void removeIfOOB() {
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity == null || cameraEntity.distanceToSqr(this.x, this.y, this.z) > (double)Mth.square((int)ParticleRainConfig.particleRadius)) {
            this.shouldFadeOut = true;
        }
    }

    protected boolean removeIfObstructed() {
        if (this.x == this.xo || this.z == this.zo) {
            this.remove();
            return true;
        }
        return false;
    }

    public Quaternionf flipItTurnwaysIfBackfaced(Quaternionf quaternion, Vector3f toCamera) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)toCamera);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        }
        return quaternion;
    }
}

