/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.mojang.serialization.DynamicOps;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.transformers.SplitPacketTransformer;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.impl.common.networking.DisplaySyncPacket;
import me.shedaniel.rei.impl.common.transfer.InputSlotCrafter;
import me.shedaniel.rei.impl.common.transfer.NewInputSlotCrafter;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;

public class RoughlyEnoughItemsNetwork {
    public static final ResourceLocation DELETE_ITEMS_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"delete_item");
    public static final ResourceLocation CREATE_ITEMS_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"create_item");
    public static final ResourceLocation CREATE_ITEMS_HOTBAR_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"create_item_hotbar");
    public static final ResourceLocation CREATE_ITEMS_GRAB_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"create_item_grab");
    public static final ResourceLocation CREATE_ITEMS_MESSAGE_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"ci_msg");
    public static final ResourceLocation MOVE_ITEMS_NEW_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"move_items_new");
    public static final ResourceLocation NOT_ENOUGH_ITEMS_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"og_not_enough");
    public static final ResourceLocation SYNC_DISPLAYS_PACKET = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"sync_displays");

    public static void onInitialize() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)DELETE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.getServer().getProfilePermissions(player.getGameProfile()) < player.getServer().getOperatorUserPermissionLevel()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.no_permission_cheat").withStyle(ChatFormatting.RED), false);
                return;
            }
            AbstractContainerMenu menu = player.containerMenu;
            if (!menu.getCarried().isEmpty()) {
                menu.setCarried(ItemStack.EMPTY);
                menu.broadcastChanges();
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.getServer().getProfilePermissions(player.getGameProfile()) < player.getServer().getOperatorUserPermissionLevel()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.no_permission_cheat").withStyle(ChatFormatting.RED), false);
                return;
            }
            ItemStack stack = (ItemStack)buf.readJsonWithCodec(ItemStack.OPTIONAL_CODEC);
            if (player.getInventory().add(stack.copy())) {
                RegistryFriendlyByteBuf newBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
                newBuf.writeJsonWithCodec(ItemStack.OPTIONAL_CODEC, (Object)stack.copy());
                newBuf.writeUtf(player.getScoreboardName(), Short.MAX_VALUE);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (RegistryFriendlyByteBuf)newBuf);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_GRAB_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.getServer().getProfilePermissions(player.getGameProfile()) < player.getServer().getOperatorUserPermissionLevel()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.no_permission_cheat").withStyle(ChatFormatting.RED), false);
                return;
            }
            AbstractContainerMenu menu = player.containerMenu;
            ItemStack itemStack = (ItemStack)buf.readJsonWithCodec(ItemStack.OPTIONAL_CODEC);
            ItemStack stack = itemStack.copy();
            if (!menu.getCarried().isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)menu.getCarried(), (ItemStack)stack)) {
                stack.setCount(Mth.clamp((int)(stack.getCount() + menu.getCarried().getCount()), (int)1, (int)stack.getMaxStackSize()));
            } else if (!menu.getCarried().isEmpty()) {
                return;
            }
            menu.setCarried(stack.copy());
            menu.broadcastChanges();
            RegistryFriendlyByteBuf newBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
            newBuf.writeJsonWithCodec(ItemStack.OPTIONAL_CODEC, (Object)stack.copy());
            newBuf.writeUtf(player.getScoreboardName(), Short.MAX_VALUE);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (RegistryFriendlyByteBuf)newBuf);
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)CREATE_ITEMS_HOTBAR_PACKET, Collections.singletonList(new SplitPacketTransformer()), (buf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            if (player.getServer().getProfilePermissions(player.getGameProfile()) < player.getServer().getOperatorUserPermissionLevel()) {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.no_permission_cheat").withStyle(ChatFormatting.RED), false);
                return;
            }
            ItemStack stack = (ItemStack)buf.readJsonWithCodec(ItemStack.OPTIONAL_CODEC);
            int hotbarSlotId = buf.readVarInt();
            if (hotbarSlotId >= 0 && hotbarSlotId < 9) {
                AbstractContainerMenu menu = player.containerMenu;
                player.getInventory().items.set(hotbarSlotId, (Object)stack.copy());
                menu.broadcastChanges();
                RegistryFriendlyByteBuf newBuf = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
                newBuf.writeJsonWithCodec(ItemStack.OPTIONAL_CODEC, (Object)stack.copy());
                newBuf.writeUtf(player.getScoreboardName(), Short.MAX_VALUE);
                NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)CREATE_ITEMS_MESSAGE_PACKET, (RegistryFriendlyByteBuf)newBuf);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.rei.failed_cheat_items"), false);
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (ResourceLocation)MOVE_ITEMS_NEW_PACKET, Collections.singletonList(new SplitPacketTransformer()), (packetByteBuf, context) -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            CategoryIdentifier category = CategoryIdentifier.of(packetByteBuf.readResourceLocation());
            AbstractContainerMenu container = player.containerMenu;
            InventoryMenu playerContainer = player.inventoryMenu;
            try {
                boolean shift = packetByteBuf.readBoolean();
                try {
                    CompoundTag nbt = packetByteBuf.readNbt();
                    int version = nbt.getInt("Version");
                    if (version != 1) {
                        throw new IllegalStateException("Server and client REI protocol version mismatch! Server: 1, Client: " + version);
                    }
                    List<InputIngredient<ItemStack>> inputs = RoughlyEnoughItemsNetwork.readInputs(context.registryAccess(), nbt.getList("Inputs", 10));
                    List<SlotAccessor> input = RoughlyEnoughItemsNetwork.readSlots(container, (Player)player, nbt.getList("InputSlots", 10));
                    List<SlotAccessor> inventory = RoughlyEnoughItemsNetwork.readSlots(container, (Player)player, nbt.getList("InventorySlots", 10));
                    NewInputSlotCrafter crafter = new NewInputSlotCrafter(container, input, inventory, inputs);
                    crafter.fillInputSlots(player, shift);
                }
                catch (InputSlotCrafter.NotEnoughMaterialsException e) {
                    if (!(container instanceof RecipeBookMenu)) {
                        return;
                    }
                }
                catch (IllegalStateException e) {
                    player.sendSystemMessage((Component)Component.translatable((String)e.getMessage()).withStyle(ChatFormatting.RED));
                }
                catch (Exception e) {
                    player.sendSystemMessage((Component)Component.translatable((String)"error.rei.internal.error", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(DisplaySyncPacket.TYPE, DisplaySyncPacket.STREAM_CODEC, List.of(new SplitPacketTransformer()));
        }
    }

    private static List<SlotAccessor> readSlots(AbstractContainerMenu menu, Player player, ListTag tag) {
        ArrayList<SlotAccessor> slots = new ArrayList<SlotAccessor>();
        for (Tag t : tag) {
            slots.add(SlotAccessorRegistry.getInstance().read(menu, player, (CompoundTag)t));
        }
        return slots;
    }

    private static List<InputIngredient<ItemStack>> readInputs(RegistryAccess registryAccess, ListTag tag) {
        ArrayList<InputIngredient<ItemStack>> inputs = new ArrayList<InputIngredient<ItemStack>>();
        for (Tag t : tag) {
            CompoundTag compoundTag = (CompoundTag)t;
            InputIngredient<EntryStack<?>> stacks = InputIngredient.of(compoundTag.getInt("Index"), (List)EntryIngredient.codec().parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.getList("Ingredient", 10)).getOrThrow());
            inputs.add(InputIngredient.withType(stacks, VanillaEntryTypes.ITEM));
        }
        return inputs;
    }
}

