/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.display;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Display
extends DisplaySpec {
    public static Codec<Display> codec() {
        return DisplaySerializerRegistry.getInstance().codec();
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Display> streamCodec() {
        return DisplaySerializerRegistry.getInstance().streamCodec();
    }

    public List<EntryIngredient> getInputEntries();

    default public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable AbstractContainerMenu menu, @Nullable Player player) {
        return CollectionUtils.mapIndexed(this.getInputEntries(), InputIngredient::of);
    }

    public List<EntryIngredient> getOutputEntries();

    default public List<EntryIngredient> getRequiredEntries() {
        return this.getInputEntries();
    }

    public CategoryIdentifier<?> getCategoryIdentifier();

    public Optional<ResourceLocation> getDisplayLocation();

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer();

    @Override
    @ApiStatus.NonExtendable
    default public Display provideInternalDisplay() {
        return this;
    }

    @Override
    @ApiStatus.NonExtendable
    default public Collection<ResourceLocation> provideInternalDisplayIds() {
        Optional<ResourceLocation> location = this.getDisplayLocation();
        if (location.isPresent()) {
            return Collections.singletonList(location.get());
        }
        return Collections.emptyList();
    }
}

