/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Internals {
    private static Function<Ingredient, EntryIngredient> ingredientToEntryIngredient = object -> (EntryIngredient)Internals.throwNotSetup();
    private static Supplier<EntryStackProvider> entryStackProvider = Internals::throwNotSetup;
    private static Supplier<EntryIngredientProvider> entryIngredientProvider = Internals::throwNotSetup;
    private static Function<ResourceLocation, EntryType<?>> entryTypeDeferred = object -> (EntryType)Internals.throwNotSetup();
    private static Supplier<PluginManager<REICommonPlugin>> commonPluginManager = Internals::throwNotSetup;
    private static Supplier<NbtHasherProvider> nbtHasherProvider = Internals::throwNotSetup;
    private static Function<String, CategoryIdentifier<?>> categoryIdentifier = object -> (CategoryIdentifier)Internals.throwNotSetup();
    private static Supplier<InternalLogger> logger = Internals::throwNotSetup;
    private static Supplier<RegistryAccess> registryAccess = Internals::throwNotSetup;

    private static <T> T throwNotSetup() {
        throw new AssertionError((Object)"REI Internals have not been initialized!");
    }

    @ApiStatus.Internal
    public static <T> void attachInstance(T instance, Class<T> clazz) {
        Internals.attachInstanceSupplier(instance, clazz.getSimpleName());
    }

    @ApiStatus.Internal
    public static <T> void attachInstanceSupplier(T instance, String name) {
        Internals.attachInstance(() -> instance, name);
    }

    public static <T> void attachInstance(T instance, String name) {
        try {
            for (Field field : Internals.class.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                field.setAccessible(true);
                field.set(null, instance);
                return;
            }
            throw new RuntimeException("Failed to attach " + String.valueOf(instance) + " with field name: " + name);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static EntryIngredient toEntryIngredient(Ingredient ingredient) {
        return ingredientToEntryIngredient.apply(ingredient);
    }

    public static EntryStackProvider getEntryStackProvider() {
        return entryStackProvider.get();
    }

    public static EntryIngredientProvider getEntryIngredientProvider() {
        return entryIngredientProvider.get();
    }

    public static EntryType<?> deferEntryType(ResourceLocation id) {
        return entryTypeDeferred.apply(id);
    }

    public static PluginManager<REICommonPlugin> getPluginManager() {
        return commonPluginManager.get();
    }

    public static EntryComparator<DataComponentMap> getComponentHasher(DataComponentType<?>[] ignoredKeys) {
        return nbtHasherProvider.get().provide(ignoredKeys);
    }

    public static <T extends Display> CategoryIdentifier<T> getCategoryIdentifier(String location) {
        return categoryIdentifier.apply(location);
    }

    public static InternalLogger getInternalLogger() {
        return logger.get();
    }

    public static RegistryAccess getRegistryAccess() {
        return registryAccess.get();
    }

    public static interface EntryStackProvider {
        public EntryStack<Unit> empty();

        public <T> EntryStack<T> of(EntryDefinition<T> var1, T var2);
    }

    public static interface EntryIngredientProvider {
        public EntryIngredient empty();

        public EntryIngredient of(EntryStack<?> var1);

        public EntryIngredient of(EntryStack<?> ... var1);

        public EntryIngredient of(Iterable<EntryStack<?>> var1);

        public EntryIngredient.Builder builder();

        public EntryIngredient.Builder builder(int var1);
    }

    public static interface NbtHasherProvider {
        public EntryComparator<DataComponentMap> provide(DataComponentType<?> ... var1);
    }
}

