/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.entries.FilteringAddRuleScreen;
import me.shedaniel.rei.impl.client.config.entries.FilteringScreen;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.rules.ManualFilteringRule;
import me.shedaniel.rei.impl.client.entry.filtering.rules.SearchFilteringRuleType;
import me.shedaniel.rei.impl.client.gui.InternalTextures;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.common.entry.type.FilteringLogic;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;

public class FilteringRulesScreen
extends Screen {
    private final FilteringScreen filteringScreen;
    private final List<FilteringRule<?>> rules;
    private RulesList rulesList;
    public Screen parent;

    public FilteringRulesScreen(FilteringScreen filteringScreen, List<FilteringRule<?>> rules) {
        super((Component)Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen"));
        this.filteringScreen = filteringScreen;
        this.rules = rules;
    }

    public void init() {
        super.init();
        MutableComponent backText = Component.literal((String)"\u21a9 ").append((Component)Component.translatable((String)"gui.back"));
        this.addRenderableWidget((GuiEventListener)new Button(this, 4, 4, Minecraft.getInstance().font.width((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.minecraft.setScreen(this.parent);
            this.parent = null;
        }, Supplier::get){});
        MutableComponent addText = Component.literal((String)" + ");
        this.addRenderableWidget((GuiEventListener)new Button(this, this.width - 4 - 20, 4, 20, 20, (Component)addText, button -> {
            FilteringAddRuleScreen screen = new FilteringAddRuleScreen(this.rules);
            screen.parent = this;
            this.minecraft.setScreen((Screen)screen);
        }, Supplier::get){});
        this.rulesList = (RulesList)this.addWidget((GuiEventListener)new RulesList(this.minecraft, this.width, this.height, 30, this.height));
        for (int i = this.rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = this.rules.get(i);
            if (rule instanceof ManualFilteringRule) {
                this.rulesList.addItem(new DefaultRuleEntry(rule, this.rules, screen -> {
                    this.filteringScreen.parent = screen;
                    return this.filteringScreen;
                }));
                continue;
            }
            this.rulesList.addItem(new DefaultRuleEntry(rule, this.rules, null));
        }
        this.rulesList.selectItem((DynamicEntryListWidget.Entry)((RuleEntry)((Object)this.rulesList.children().get(0))));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.rulesList.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private static <Cache> Function<Screen, Screen> placeholderScreen(FilteringRule<Cache> r) {
        return x$0 -> {
            class PlaceholderScreen
            extends OptionEntriesScreen {
                final /* synthetic */ FilteringRule val$r;

                public PlaceholderScreen(Screen screen) {
                    this.val$r = screen;
                    super((Component)Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen"), parent);
                }

                @Override
                public void addEntries(Consumer<OptionEntriesScreen.ListEntry> entryConsumer) {
                    this.addEmpty(entryConsumer, 10);
                    Function<Boolean, Component> function = bool -> Component.translatable((String)("rule.roughlyenoughitems.filtering.search.show." + bool));
                    Map<FilteringContextType, Set<HashedEntryStackWrapper>> stacks = FilteringLogic.hidden(List.of(this.val$r), false, false, EntryRegistry.getInstance().getEntryStacks().collect(Collectors.toList()));
                    entryConsumer.accept(new OptionEntriesScreen.SubListEntry(() -> (Component)function.apply(true), Collections.singletonList(new SearchFilteringRuleType.EntryStacksRuleEntry((Supplier<Iterable<EntryWidget>>)Suppliers.ofInstance(CollectionUtils.map((Collection)stacks.get((Object)FilteringContextType.SHOWN), stack -> (EntryWidget)Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().entry(stack.unwrap().normalize())))))));
                    this.addEmpty(entryConsumer, 10);
                    entryConsumer.accept(new OptionEntriesScreen.SubListEntry(() -> (Component)function.apply(false), Collections.singletonList(new SearchFilteringRuleType.EntryStacksRuleEntry((Supplier<Iterable<EntryWidget>>)Suppliers.ofInstance(CollectionUtils.map((Collection)stacks.get((Object)FilteringContextType.HIDDEN), stack -> (EntryWidget)Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().entry(stack.unwrap().normalize())))))));
                }

                @Override
                public void save() {
                }
            }
            return new PlaceholderScreen(x$0, r);
        };
    }

    public static class RulesList
    extends UpdatedListWidget<RuleEntry> {
        private boolean inFocus;

        public RulesList(Minecraft client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }

        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.children().get(index));
        }

        protected int addItem(RuleEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (super.mouseClicked(double_1, double_2, int_1)) {
                return true;
            }
            RuleEntry item = (RuleEntry)this.getItemAtPosition(double_1, double_2);
            if (item != null) {
                this.client.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.selectItem((DynamicEntryListWidget.Entry)item);
                this.setFocused((GuiEventListener)item);
                this.setDragging(true);
                return true;
            }
            return false;
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class DefaultRuleEntry
    extends RuleEntry {
        private final Button configureButton;
        private final Button deleteButton;
        private final Function<Screen, Screen> screenFunction;

        public DefaultRuleEntry(FilteringRule<?> rule, List<FilteringRule<?>> rules, Function<Screen, Screen> screenFunction) {
            super(rule);
            this.screenFunction = Objects.requireNonNullElseGet(screenFunction == null ? rule.getType().createEntryScreen(rule) : screenFunction, () -> FilteringRulesScreen.placeholderScreen(rule));
            this.configureButton = new Button(this, 0, 0, 20, 20, Component.nullToEmpty(null), button -> Minecraft.getInstance().setScreen(this.screenFunction.apply(Minecraft.getInstance().screen)), Supplier::get){

                public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                    super.renderWidget(graphics, mouseX, mouseY, delta);
                    graphics.blit(RenderType::guiTextured, InternalTextures.CHEST_GUI_TEXTURE, this.getX() + 3, this.getY() + 3, 0.0f, 0.0f, 14, 14, 256, 256);
                }
            };
            MutableComponent deleteText = Component.translatable((String)"config.roughlyenoughitems.filteringRulesScreen.delete");
            this.deleteButton = new Button(this, 0, 0, Minecraft.getInstance().font.width((FormattedText)deleteText) + 10, 20, (Component)deleteText, button -> {
                Screen screen = Minecraft.getInstance().screen;
                rules.remove(rule);
                screen.init(Minecraft.getInstance(), screen.width, screen.height);
            }, Supplier::get){};
            this.configureButton.active = this.screenFunction != null;
            this.deleteButton.active = !rule.getType().isSingular();
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            Minecraft client = Minecraft.getInstance();
            Component title = this.getRule().getType().getTitle(this.getRule());
            int i = client.font.width((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)title, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(titleTrimmed), x + 2, y + 1, 0xFFFFFF);
            } else {
                graphics.drawString(client.font, title.getVisualOrderText(), x + 2, y + 1, 0xFFFFFF);
            }
            Component subtitle = this.getRule().getType().getSubtitle(this.getRule());
            i = client.font.width((FormattedText)subtitle);
            if (i > entryWidth - 28) {
                FormattedText subtitleTrimmed = FormattedText.composite((FormattedText[])new FormattedText[]{client.font.substrByWidth((FormattedText)subtitle, entryWidth - 28 - client.font.width("...")), FormattedText.of((String)"...")});
                graphics.drawString(client.font, Language.getInstance().getVisualOrder(subtitleTrimmed), x + 2, y + 12, 0x808080);
            } else {
                graphics.drawString(client.font, subtitle.getVisualOrderText(), x + 2, y + 12, 0x808080);
            }
            this.configureButton.setX(x + entryWidth - 25);
            this.configureButton.setY(y + 1);
            this.configureButton.render(graphics, mouseX, mouseY, delta);
            this.deleteButton.setX(x + entryWidth - 27 - this.deleteButton.getWidth());
            this.deleteButton.setY(y + 1);
            this.deleteButton.render(graphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Arrays.asList(this.configureButton, this.deleteButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Arrays.asList(this.configureButton, this.deleteButton);
        }
    }

    public static abstract class RuleEntry
    extends UpdatedListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;

        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }

        public FilteringRule<?> getRule() {
            return this.rule;
        }

        public int getItemHeight() {
            return 26;
        }
    }
}

