/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@ApiStatus.Internal
public final class RecipeDisplayExporter {
    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, DisplaySpec display, List<Widget> widgets, boolean toast) {
        RecipeDisplayExporter.exportRecipe(rectangle, display, widgets);
        if (toast) {
            ExportRecipeIdentifierToast.addToast(I18n.get((String)"msg.rei.exported_recipe", (Object[])new Object[0]), I18n.get((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
        }
    }

    private static File getExportFilename(DisplaySpec display, File directory) {
        Collection<ResourceLocation> locations = display.provideInternalDisplayIds();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        if (!locations.isEmpty()) {
            string = locations.iterator().next().toString().replace('/', '_').replace(':', '_');
        }
        int i = 1;
        File file;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private static void exportRecipe(Rectangle rectangle, DisplaySpec display, List<Widget> widgets) {
        Minecraft client = Minecraft.getInstance();
        Window window = client.getWindow();
        TextureTarget renderTarget = new TextureTarget(window.getWidth(), window.getHeight(), true);
        renderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        renderTarget.bindWrite(true);
        RenderSystem.clear((int)256);
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        Matrix4fStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushMatrix();
        poseStack.identity();
        poseStack.translate(0.0f, 0.0f, -2000.0f);
        Lighting.setupFor3DItems();
        GuiGraphics graphics = new GuiGraphics(client, client.renderBuffers().bufferSource());
        for (Widget widget : widgets) {
            widget.render(graphics, -1, -1, 0.0f);
        }
        NativeImage nativeImage = new NativeImage(renderTarget.width, renderTarget.height, false);
        RenderSystem.bindTexture((int)renderTarget.getColorTextureId());
        nativeImage.downloadTexture(0, false);
        nativeImage.flipY();
        int outWidth = (int)((double)rectangle.width * window.getGuiScale());
        int outHeight = (int)((double)rectangle.height * window.getGuiScale());
        NativeImage strippedImage = new NativeImage(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.setPixel(x, y, nativeImage.getPixel(x + (int)((double)rectangle.x * window.getGuiScale()), y + (int)((double)rectangle.y * window.getGuiScale())));
            }
        }
        Util.ioPool().execute(() -> {
            try {
                File export = new File(Minecraft.getInstance().gameDirectory, "rei_exports/" + display.provideInternalDisplay().getCategoryIdentifier().toString().replace('/', '_').replace(':', '_'));
                export.mkdirs();
                strippedImage.writeToFile(RecipeDisplayExporter.getExportFilename(display, export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
            }
        });
        renderTarget.destroyBuffers();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        poseStack.popMatrix();
    }
}

