/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.config.components;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import me.shedaniel.rei.impl.client.gui.config.options.OptionCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class ConfigCategoryEntryWidget {
    public static WidgetWithBounds create(OptionCategory category, int width) {
        boolean hasDescription = !category.getDescription().getString().endsWith(".desc");
        Label label = Widgets.createLabel(new Point(21, hasDescription ? 5 : 7), (Component)category.getName().copy().withStyle(style -> style.withColor(-4144960))).leftAligned();
        Font font = Minecraft.getInstance().font;
        MutableComponent description = category.getDescription().copy().withStyle(style -> style.withColor(-5197648));
        Widget descriptionLabel = Widgets.createDrawableWidget((graphics, mouseX, mouseY, delta) -> ConfigCategoryEntryWidget.renderTextScrolling(graphics, (Component)description, 0, 0, (int)((double)(width - 21 - 6) / 0.75), -5197648));
        Rectangle bounds = new Rectangle(0, 0, width, hasDescription ? 24 : 21);
        return Widgets.concatWithBounds(bounds, label, hasDescription ? Widgets.withTranslate(Widgets.withTranslate(descriptionLabel, new Matrix4f().scale(0.75f, 0.75f, 0.75f)), 21.0, 15.0, 0.0) : Widgets.noOp(), Widgets.createTexturedWidget(category.getIcon(), new Rectangle(3, hasDescription ? 5 : 3, 16, 16), 0.0f, 0.0f, 1, 1, 1, 1));
    }

    public static WidgetWithBounds createTiny(OptionCategory category) {
        Component[] componentArray;
        Rectangle bounds = new Rectangle(0, 0, 16, 16);
        if (category.getDescription().getString().endsWith(".desc")) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = category.getName();
        } else {
            Component[] componentArray3 = new Component[2];
            componentArray3[0] = category.getName().copy().withStyle(ChatFormatting.UNDERLINE);
            componentArray = componentArray3;
            componentArray3[1] = category.getDescription();
        }
        Component[] texts = componentArray;
        return Widgets.withTooltip(Widgets.withBounds(Widgets.createTexturedWidget(category.getIcon(), bounds, 0.0f, 0.0f, 1, 1, 1, 1), bounds), texts);
    }

    private static void renderTextScrolling(GuiGraphics graphics, Component text, int x, int y, int width, int color) {
        ConfigCategoryEntryWidget.renderTextScrolling(graphics, text.getVisualOrderText(), x, y, width, color);
    }

    private static void renderTextScrolling(GuiGraphics graphics, FormattedCharSequence text, int x, int y, int width, int color) {
        try (CloseableScissors scissors = Widget.scissor(graphics, new Rectangle(x, y, width, y + 9));){
            Font font = Minecraft.getInstance().font;
            int textWidth = font.width(text);
            textWidth = MatrixUtils.transform((Matrix4f)MatrixUtils.inverse((Matrix4f)graphics.pose().last().pose()), (Rectangle)new Rectangle((int)0, (int)0, (int)textWidth, (int)100)).width;
            width = MatrixUtils.transform((Matrix4f)MatrixUtils.inverse((Matrix4f)graphics.pose().last().pose()), (Rectangle)new Rectangle((int)0, (int)0, (int)width, (int)100)).width;
            if (textWidth > width && !ConfigUtils.isReducedMotion()) {
                graphics.pose().pushPose();
                float textX = (float)(System.currentTimeMillis() % (long)((textWidth + 10) * textWidth / 3)) / (float)textWidth * 3.0f;
                graphics.pose().translate(-textX, 0.0f, 0.0f);
                graphics.drawString(font, text, x + width - textWidth - 10, y, color);
                graphics.drawString(font, text, x + width, y, color);
                graphics.pose().popPose();
            } else {
                graphics.drawString(font, text, x, y, color);
            }
        }
    }
}

