/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.modules.entries.SubMenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.LateRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Menu
extends WidgetWithBounds
implements LateRenderable {
    public final Point menuStartPoint;
    public final boolean facingRight;
    public final boolean facingDownwards;
    public final ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
    private final List<FavoriteMenuEntry> entries = Lists.newArrayList();
    public final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            int i = 0;
            for (FavoriteMenuEntry entry : Menu.this.children()) {
                i += entry.getEntryHeight();
            }
            return i;
        }

        public Rectangle getBounds() {
            return Menu.this.getInnerBounds();
        }

        public boolean hasScrollBar() {
            return Menu.this.hasScrollBar();
        }
    };

    public Menu(Rectangle menuStart, Collection<FavoriteMenuEntry> entries, boolean sort) {
        this.buildEntries(entries, sort);
        int fullWidth = Minecraft.getInstance().screen.width;
        int fullHeight = Minecraft.getInstance().screen.height;
        boolean facingRight = true;
        this.facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
        int y = this.facingDownwards ? menuStart.getMaxY() : menuStart.y - (this.scrolling.getMaxScrollHeight() + 2);
        boolean hasScrollBar = this.scrolling.getMaxScrollHeight() > this.getInnerHeight(y);
        int menuWidth = this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0);
        if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
            facingRight = false;
        } else if (!facingRight && menuStart.x < menuWidth + 10) {
            facingRight = true;
        }
        this.facingRight = facingRight;
        int x = facingRight ? menuStart.x : menuStart.getMaxX() - (this.getMaxEntryWidth() + 2 + (hasScrollBar ? 6 : 0));
        this.menuStartPoint = new Point(x, y);
        Rectangle createBounds = this.createBounds();
        this.bounds.setAs((Object)new FloatingRectangle(facingRight ? (double)createBounds.x : (double)createBounds.getMaxX(), this.facingDownwards ? (double)createBounds.y : (double)createBounds.getMaxY(), 0.1, 0.1));
    }

    private void buildEntries(Collection<FavoriteMenuEntry> entries, boolean sort) {
        this.entries.clear();
        this.entries.addAll(entries);
        if (sort) {
            this.entries.sort(Comparator.comparing(entry -> entry instanceof SubMenuEntry ? 0 : 1).thenComparing(entry -> {
                String string;
                if (entry instanceof SubMenuEntry) {
                    SubMenuEntry menuEntry = (SubMenuEntry)entry;
                    string = menuEntry.text.getString();
                } else {
                    string = "";
                }
                return string;
            }));
        }
        for (FavoriteMenuEntry entry2 : this.entries) {
            entry2.closeMenu = ScreenOverlayImpl.getInstance().menuAccess()::close;
            if (!(entry2 instanceof SubMenuEntry)) continue;
            SubMenuEntry menuEntry = (SubMenuEntry)entry2;
            menuEntry.setParent(this);
        }
    }

    @Override
    public Rectangle getBounds() {
        return ((FloatingRectangle)this.bounds.value()).getBounds();
    }

    public Rectangle createBounds() {
        return new Rectangle(this.menuStartPoint.x, this.menuStartPoint.y, this.getMaxEntryWidth() + 2 + (this.hasScrollBar() ? 6 : 0), this.getInnerHeight(this.menuStartPoint.y) + 2);
    }

    public Rectangle getInnerBounds() {
        Rectangle rectangle = ((FloatingRectangle)this.bounds.value()).getBounds();
        return new Rectangle(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
    }

    public boolean hasScrollBar() {
        return this.scrolling.getMaxScrollHeight() > this.getInnerHeight(this.menuStartPoint.y);
    }

    public int getInnerHeight(int y) {
        return Math.min(this.scrolling.getMaxScrollHeight(), this.minecraft.screen.height - 20 - y);
    }

    public int getMaxEntryWidth() {
        int i = 0;
        for (FavoriteMenuEntry entry : this.children()) {
            if (entry.getEntryWidth() <= i) continue;
            i = entry.getEntryWidth();
        }
        return Math.max(10, i);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        FavoriteMenuEntry menuEntry;
        this.bounds.setTo((Object)this.createBounds().getFloatingBounds(), ConfigObject.getInstance().isReducedMotion() ? 0L : 300L);
        this.bounds.update((double)delta);
        Rectangle bounds = this.getBounds();
        Rectangle innerBounds = this.getInnerBounds();
        graphics.fill(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), this.containsMouse(mouseX, mouseY) ? (REIRuntime.getInstance().isDarkThemeEnabled() ? -17587 : -1) : -6250336);
        graphics.fill(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.getMaxY(), -16777216);
        boolean contains = innerBounds.contains(mouseX, mouseY);
        GuiEventListener guiEventListener = this.getFocused();
        FavoriteMenuEntry focused = guiEventListener instanceof FavoriteMenuEntry ? (menuEntry = (FavoriteMenuEntry)guiEventListener) : null;
        int currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        for (FavoriteMenuEntry child : this.children()) {
            boolean containsMouse;
            boolean bl = containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            if (containsMouse) {
                focused = child;
            }
            currentY += child.getEntryHeight();
        }
        currentY = innerBounds.y - this.scrolling.scrollAmountInt();
        graphics.enableScissor(this.scrolling.getScissorBounds().x, this.scrolling.getScissorBounds().y, this.scrolling.getScissorBounds().getMaxX(), this.scrolling.getScissorBounds().getMaxY());
        for (FavoriteMenuEntry child : this.children()) {
            boolean rendering = currentY + child.getEntryHeight() >= innerBounds.y && currentY <= innerBounds.getMaxY();
            boolean containsMouse = contains && mouseY >= currentY && mouseY < currentY + child.getEntryHeight();
            child.updateInformation(innerBounds.x, currentY, focused == child || containsMouse, containsMouse, rendering, this.getMaxEntryWidth());
            if (rendering) {
                child.render(graphics, mouseX, mouseY, delta);
            }
            currentY += child.getEntryHeight();
        }
        graphics.disableScissor();
        this.setFocused((GuiEventListener)focused);
        this.scrolling.renderScrollBar(graphics, 0, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        this.scrolling.updatePosition(delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button) || this.getInnerBounds().contains(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.getInnerBounds().contains(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        for (FavoriteMenuEntry child : this.children()) {
            if (!(child instanceof SubMenuEntry) || !child.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        for (FavoriteMenuEntry child : this.children()) {
            if (!child.containsMouse(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public List<FavoriteMenuEntry> children() {
        return this.entries;
    }
}

