/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen;

import me.shedaniel.rei.impl.client.gui.modules.Menu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ScreenWithMenu
extends Screen {
    @Nullable
    private Menu menu;

    protected ScreenWithMenu(Component component) {
        super(component);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        if (this.menu != null) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            this.menu.render(graphics, mouseX, mouseY, delta);
            graphics.pose().popPose();
        }
    }

    protected void setMenu(@Nullable Menu menu) {
        this.menu = menu;
    }

    protected void closeMenu() {
        this.menu = null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.menu != null) {
            if (!this.menu.mouseClicked(mouseX, mouseY, button)) {
                this.menu = null;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.menu != null && this.menu.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.menu != null && this.menu.mouseScrolled(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, amountX, amountY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.menu != null && this.menu.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

