/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.generic;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class OptionEntriesScreen
extends Screen {
    private ListWidget listWidget;
    public Screen parent;

    public OptionEntriesScreen(Component title, Screen screen) {
        super(title);
        this.parent = screen;
    }

    public void init() {
        super.init();
        if (this.listWidget != null) {
            this.save();
        }
        MutableComponent doneText = Component.translatable((String)"gui.done");
        int width = Minecraft.getInstance().font.width((FormattedText)doneText);
        this.addRenderableWidget((GuiEventListener)new Button(this, this.width - 4 - width - 10, 4, width + 10, 20, (Component)doneText, button -> {
            this.save();
            this.minecraft.setScreen(this.parent);
        }, Supplier::get){});
        this.listWidget = (ListWidget)this.addWidget((GuiEventListener)new ListWidget(this.minecraft, this.width, this.height, 30, this.height));
        this.addEntries(ruleEntry -> this.listWidget.addItem((ListEntry)((Object)ruleEntry)));
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    public abstract void addEntries(Consumer<ListEntry> var1);

    public abstract void save();

    public void addText(Consumer<ListEntry> entryConsumer, FormattedText text) {
        for (FormattedCharSequence s : this.font.split(text, this.width - 80)) {
            entryConsumer.accept(new TextListEntry(s));
        }
    }

    public void addEmpty(Consumer<ListEntry> entryConsumer, int height) {
        entryConsumer.accept(new EmptyListEntry(height));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.listWidget.render(graphics, mouseX, mouseY, delta);
        graphics.drawString(this.font, this.title.getVisualOrderText(), (int)((float)this.width / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f), 12, -1);
    }

    public static class ListWidget
    extends UpdatedListWidget<ListEntry> {
        public ListWidget(Minecraft client, int width, int height, int top, int bottom) {
            super(client, width, height, top, bottom);
        }

        protected int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class TextListEntry
    extends ListEntry {
        private final FormattedCharSequence text;

        public TextListEntry(FormattedCharSequence text) {
            this.text = text;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.drawString(Minecraft.getInstance().font, this.text, x + 5, y, -1);
        }

        public int getItemHeight() {
            return 12;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static class EmptyListEntry
    extends ListEntry {
        private final int height;

        public EmptyListEntry(int height) {
            this.height = height;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }

        public int getItemHeight() {
            return this.height;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class ListEntry
    extends UpdatedListWidget.ElementEntry<ListEntry> {
    }

    public static class SubListEntry
    extends ListEntry {
        private static final ResourceLocation CONFIG_TEX = ResourceLocation.fromNamespaceAndPath((String)"cloth-config2", (String)"textures/gui/cloth_config.png");
        private final CategoryLabelWidget widget;
        private final List<ListEntry> rules;
        private final List<GuiEventListener> children;
        private boolean expanded;
        private Supplier<Component> name;

        public SubListEntry(Supplier<Component> name, List<ListEntry> rules) {
            this.rules = rules;
            this.widget = new CategoryLabelWidget();
            this.name = name;
            this.expanded = true;
            this.children = new ArrayList<ListEntry>(rules);
            this.children.add(this.widget);
        }

        public List<ListEntry> getRules() {
            return this.rules;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.widget.rectangle.x = x + 3;
            this.widget.rectangle.y = y;
            this.widget.rectangle.width = entryWidth - 6;
            this.widget.rectangle.height = 24;
            graphics.blit(RenderType::guiTextured, CONFIG_TEX, x + 3, y + 5, 24.0f, (float)((this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0)), 9, 9, 256, 256);
            graphics.drawString(Minecraft.getInstance().font, this.name.get().getVisualOrderText(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
            for (ListEntry performanceEntry : this.rules) {
                performanceEntry.setParent(this.getParent());
            }
            if (this.expanded) {
                int yy = y + 24;
                for (ListEntry entry : this.rules) {
                    entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.getFocused() == entry, delta);
                    yy += entry.getItemHeight();
                }
            }
        }

        public int getMorePossibleHeight() {
            if (!this.expanded) {
                return -1;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i = 24;
            for (ListEntry entry : this.rules) {
                i += entry.getItemHeight();
                if (entry.getMorePossibleHeight() < 0) continue;
                list.add(i + entry.getMorePossibleHeight());
            }
            list.add(i);
            return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
        }

        public int getItemHeight() {
            if (!this.expanded) {
                return 24;
            }
            int i = 24;
            for (ListEntry entry : this.rules) {
                i += entry.getItemHeight();
            }
            return i;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public class CategoryLabelWidget
        implements GuiEventListener {
            private final Rectangle rectangle = new Rectangle();

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.rectangle.contains(mouseX, mouseY)) {
                    SubListEntry.this.expanded = !SubListEntry.this.expanded;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    return true;
                }
                return false;
            }

            @Nullable
            public ComponentPath nextFocusPath(FocusNavigationEvent event) {
                return null;
            }

            public void setFocused(boolean bl) {
            }

            public boolean isFocused() {
                return false;
            }
        }
    }

    public static class BooleanListEntry
    extends ButtonListEntry {
        private Boolean b;

        public BooleanListEntry(int width, boolean b, Function<Boolean, Component> textFunction) {
            super(width, self -> {
                if (((BooleanListEntry)self).b == null) {
                    ((BooleanListEntry)self).b = b;
                }
                return (Component)textFunction.apply(((BooleanListEntry)self).b);
            }, (ButtonListEntry self, Button button) -> {
                ((BooleanListEntry)self).b = ((BooleanListEntry)self).b == false;
            });
        }

        public boolean getBoolean() {
            return this.b;
        }
    }

    public static class ButtonListEntry
    extends ListEntry {
        private final Button widget;

        public ButtonListEntry(int width, Function<ButtonListEntry, Component> textFunction, BiConsumer<ButtonListEntry, Button> buttonConsumer) {
            this.widget = new Button(this, 0, 0, 100, 20, textFunction.apply(this), button -> {
                buttonConsumer.accept(this, button);
                button.setMessage((Component)textFunction.apply(this));
            }, Supplier::get){};
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.setX(x + 2);
            this.widget.setY(y);
            this.widget.render(graphics, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.widget);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.widget);
        }
    }

    public static class TextFieldListEntry
    extends ListEntry {
        private final EditBox widget;

        public TextFieldListEntry(int width, Consumer<EditBox> widgetConsumer) {
            this.widget = new EditBox(Minecraft.getInstance().font, 0, 0, width, 18, Component.nullToEmpty((String)""));
            widgetConsumer.accept(this.widget);
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.setX(x + 2);
            this.widget.setY(y + 2);
            this.widget.render(graphics, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        public EditBox getWidget() {
            return this.widget;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.widget);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.widget);
        }
    }
}

