/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import me.shedaniel.rei.impl.client.gui.error.ErrorsEntryListWidget;
import me.shedaniel.rei.impl.client.gui.error.ErrorsScreen;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.Bootstrap;

public class CatchingExceptionUtils {
    public static void handleThrowable(Throwable throwable, String task) {
        CrashReport report = CrashReportUtils.essential(throwable, task);
        File reportsFolder = new File(Minecraft.getInstance().gameDirectory, "crash-reports");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        File crashReportFile = new File(reportsFolder, "crash-" + format.format(new Date()) + "-client.txt");
        report.saveToFile(crashReportFile.toPath(), ReportType.CRASH);
        Bootstrap.realStdoutPrintln((String)report.getFriendlyReport(ReportType.CRASH));
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(Component.literal((String)I18n.get((String)"text.rei.crash.description", (Object[])new Object[]{report.getTitle()})));
        components.add(width -> new ErrorsEntryListWidget.LinkEntry((Component)Component.translatable((String)"text.rei.crash.crash_report"), crashReportFile.toURI().toString(), (int)width));
        components.add(Component.empty());
        components.add(Component.literal((String)report.getFriendlyReport(ReportType.CRASH).replace("\t", "    ")));
        Minecraft.getInstance().setScreen((Screen)new ErrorsScreen((Component)Component.translatable((String)"text.rei.crash.title"), components, null, false));
    }
}

