/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.math.Transformation;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class DelegateWidgetWithTranslate
extends DelegateWidget {
    private final Supplier<Matrix4f> translate;

    public DelegateWidgetWithTranslate(WidgetWithBounds widget, Supplier<Matrix4f> translate) {
        super(widget);
        this.translate = translate;
    }

    protected Matrix4f translate() {
        return this.translate.get();
    }

    protected final Matrix4f inverseTranslate() {
        return MatrixUtils.inverse(this.translate());
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.pose().pushPose();
        graphics.pose().last().pose().mul((Matrix4fc)this.translate());
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        super.render(graphics, (int)mouse.x(), (int)mouse.y(), delta);
        graphics.pose().popPose();
    }

    private Vector4f transformMouse(double mouseX, double mouseY) {
        Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
        this.inverseTranslate().transform(mouse);
        return mouse;
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.containsMouse(mouse.x(), mouse.y());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseClicked((double)mouse.x(), (double)mouse.y(), button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseReleased(mouse.x(), mouse.y(), button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseDragged(mouse.x(), mouse.y(), button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        Vector4f mouse = this.transformMouse(mouseX, mouseY);
        return super.mouseScrolled(mouse.x(), mouse.y(), amountX, amountY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.keyPressed(keyCode, scanCode, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.keyReleased(keyCode, scanCode, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean charTyped(char character, int modifiers) {
        try {
            Widget.translateMouse(this.inverseTranslate());
            boolean bl = super.charTyped(character, modifiers);
            return bl;
        }
        finally {
            Widget.popMouse();
        }
    }

    @Override
    public double getZRenderingPriority() {
        Transformation transformation = new Transformation(this.translate());
        return (double)transformation.getTranslation().z() + super.getZRenderingPriority();
    }

    @Override
    public Rectangle getBounds() {
        return MatrixUtils.transform(this.translate(), super.getBounds());
    }
}

