/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

public class MergedWidgetWithBounds
extends WidgetWithBounds {
    private final Supplier<Rectangle> bounds;
    private final List<Widget> widgets;

    public MergedWidgetWithBounds(Supplier<Rectangle> bounds, List<Widget> widgets) {
        this.bounds = bounds;
        this.widgets = widgets;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (Widget widget : this.widgets) {
            widget.render(graphics, mouseX, mouseY, delta);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amountY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(mouseX, mouseY, amountX, amountY)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.keyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean charTyped(char character, int modifiers) {
        for (Widget widget : this.widgets) {
            if (!widget.charTyped(character, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (Widget widget : this.widgets) {
            if (!widget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getZRenderingPriority() {
        return CollectionUtils.max(this.widgets, Comparator.comparingDouble(Widget::getZRenderingPriority)).map(Widget::getZRenderingPriority).orElse(0.0);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds.get();
    }

    @Override
    @Deprecated
    public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
        Rectangle clone = this.getBounds().clone();
        this.getBounds().setBounds(bounds);
        this.render(graphics, mouseX, mouseY, delta);
        this.getBounds().setBounds(clone);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.containsMouse(mouseX, mouseY)) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }
}

