/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.utils.PanelTextures;
import me.shedaniel.rei.impl.client.gui.config.options.ConfigUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.ApiStatus;

public final class PanelWidget
extends Panel {
    private static final PanelWidget TEMP = new PanelWidget(new Rectangle());
    private Rectangle bounds;
    private int color = -1;
    private ResourceLocation texture;
    private ResourceLocation darkTexture;
    private Predicate<Panel> rendering = Predicates.alwaysTrue();
    private NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public PanelWidget(Rectangle bounds) {
        this.bounds = Objects.requireNonNull(bounds);
        this.setTexture(PanelTextures.DEFAULT);
    }

    @Override
    public void setTexture(ResourceLocation texture, ResourceLocation darkTexture) {
        this.texture = texture;
        this.darkTexture = darkTexture;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public Predicate<Panel> getRendering() {
        return this.rendering;
    }

    @Override
    public void setRendering(Predicate<Panel> rendering) {
        this.rendering = Objects.requireNonNull(rendering);
    }

    @ApiStatus.Internal
    public void setDarkBackgroundAlpha(NumberAnimator<Float> darkBackgroundAlpha) {
        this.darkBackgroundAlpha = darkBackgroundAlpha;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        if (ConfigUtils.isReducedMotion()) {
            this.darkBackgroundAlpha.completeImmediately();
        }
        if (!this.getRendering().test(this)) {
            return;
        }
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        float alpha = (float)(this.color >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderBackground(graphics, x, y, width, height, false, alpha, red, green, blue);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha > 0.0f) {
            this.renderBackground(graphics, x, y, width, height, true, ((Float)this.darkBackgroundAlpha.value()).floatValue() * alpha, red, green, blue);
        }
    }

    public void renderBackground(GuiGraphics graphics, int x, int y, int width, int height, boolean dark, float alpha, float red, float green, float blue) {
        ResourceLocation texture = dark ? this.darkTexture : this.texture;
        graphics.blitSprite(RenderType::guiTextured, texture, x, y, width, height, ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue));
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

