/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.vertex.VertexConsumer;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class TexturedDrawableConsumer
implements DrawableConsumer {
    private ResourceLocation identifier;
    private int x;
    private int y;
    private int width;
    private int height;
    private int uWidth;
    private int vHeight;
    private int textureWidth;
    private int textureHeight;
    private float u;
    private float v;

    public TexturedDrawableConsumer(ResourceLocation identifier, int x, int y, int width, int height, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.identifier = identifier;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.drawSpecial(source -> TexturedDrawableConsumer.innerBlit(source.getBuffer(RenderType.guiTextured((ResourceLocation)this.identifier)), graphics.pose().last().pose(), this.x, this.x + this.width, this.y, this.y + this.height, 0, this.uWidth, this.vHeight, this.u, this.v, this.textureWidth, this.textureHeight));
    }

    private static void innerBlit(VertexConsumer consumer, Matrix4f matrix, int xStart, int xEnd, int yStart, int yEnd, int z, int width, int height, float u, float v, int texWidth, int texHeight) {
        TexturedDrawableConsumer.innerBlit(consumer, matrix, xStart, xEnd, yStart, yEnd, z, u / (float)texWidth, (u + (float)width) / (float)texWidth, v / (float)texHeight, (v + (float)height) / (float)texHeight);
    }

    private static void innerBlit(VertexConsumer consumer, Matrix4f matrix, int xStart, int xEnd, int yStart, int yEnd, int z, float uStart, float uEnd, float vStart, float vEnd) {
        consumer.addVertex(matrix, (float)xStart, (float)yEnd, (float)z).setUv(uStart, vEnd).setColor(-1);
        consumer.addVertex(matrix, (float)xEnd, (float)yEnd, (float)z).setUv(uEnd, vEnd).setColor(-1);
        consumer.addVertex(matrix, (float)xEnd, (float)yStart, (float)z).setUv(uEnd, vStart).setColor(-1);
        consumer.addVertex(matrix, (float)xStart, (float)yStart, (float)z).setUv(uStart, vStart).setColor(-1);
    }
}

