/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.region;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.joml.Matrix4f;

public class RegionRenderingDebugger {
    public boolean debugTime;
    private double lastAverageDebugTime;
    private double averageDebugTime;
    private double lastTotalDebugTime;
    private double totalDebugTime;
    private double totalDebugTimeDelta;
    public MutableInt size = new MutableInt();
    public MutableLong time = new MutableLong();

    public void render(GuiGraphics graphics, int x, int y, float delta) {
        long totalTimeStart = this.debugTime ? System.nanoTime() : 0L;
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        if (this.debugTime) {
            long totalTime = System.nanoTime() - totalTimeStart;
            this.averageDebugTime += (double)this.time.getValue().longValue() / this.size.doubleValue() * (double)delta;
            this.totalDebugTime += (double)totalTime / 1000000.0 * (double)delta;
            this.totalDebugTimeDelta += (double)delta;
            if (this.totalDebugTimeDelta >= 20.0) {
                this.lastAverageDebugTime = this.averageDebugTime / this.totalDebugTimeDelta;
                this.lastTotalDebugTime = this.totalDebugTime / this.totalDebugTimeDelta;
                this.averageDebugTime = 0.0;
                this.totalDebugTime = 0.0;
                this.totalDebugTimeDelta = 0.0;
            } else if (this.lastAverageDebugTime == 0.0) {
                this.lastAverageDebugTime = (double)this.time.getValue().longValue() / this.size.doubleValue();
                this.totalDebugTime = (double)totalTime / 1000000.0;
            }
            MutableComponent debugText = Component.literal((String)String.format("%d entries, avg. %.0fns, ttl. %.2fms, %s fps", this.size.getValue(), this.lastAverageDebugTime, this.lastTotalDebugTime, minecraft.fpsString.split(" ")[0]));
            int stringWidth = font.width((FormattedText)debugText);
            int n = Math.min(x, minecraft.screen.width - stringWidth - 2);
            Objects.requireNonNull(font);
            graphics.fillGradient(n, y, x + stringWidth + 2, y + 9 + 2, -16777216, -16777216);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0, 0.0, 500.0);
            graphics.drawSpecial(arg_0 -> RegionRenderingDebugger.lambda$render$0(graphics, font, (Component)debugText, x, minecraft, stringWidth, y, arg_0));
            graphics.pose().popPose();
        }
        this.size.setValue(0);
        this.time.setValue(0L);
    }

    private static /* synthetic */ void lambda$render$0(GuiGraphics graphics, Font font, Component debugText, int x, Minecraft minecraft, int stringWidth, int y, MultiBufferSource source) {
        Matrix4f matrix = graphics.pose().last().pose();
        font.drawInBatch(debugText.getVisualOrderText(), (float)Math.min(x + 2, minecraft.screen.width - stringWidth), (float)(y + 2), -1, false, matrix, source, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

