/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.comparison;

import com.google.common.base.Predicates;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import org.jetbrains.annotations.Nullable;

public enum NbtHasherProviderImpl implements Internals.NbtHasherProvider
{
    INSTANCE;

    private final EntryComparator<DataComponentMap> defaultHasher = this._provide(new DataComponentType[0]);

    @Override
    public EntryComparator<DataComponentMap> provide(DataComponentType<?> ... ignoredKeys) {
        if (ignoredKeys == null || ignoredKeys.length == 0) {
            return this.defaultHasher;
        }
        return this._provide(ignoredKeys);
    }

    private EntryComparator<DataComponentMap> _provide(DataComponentType<?> ... ignoredKeys) {
        return new Hasher(ignoredKeys);
    }

    private static class Hasher
    implements EntryComparator<DataComponentMap> {
        @Nullable
        private final Predicate<DataComponentType<?>> filter;

        private Hasher(@Nullable DataComponentType<?>[] ignoredKeys) {
            if (ignoredKeys == null || ignoredKeys.length == 0) {
                this.filter = null;
            } else if (ignoredKeys.length == 1) {
                DataComponentType<?> s = ignoredKeys[0];
                this.filter = key -> !Objects.equals(s, key);
            } else {
                ReferenceOpenHashSet set = new ReferenceOpenHashSet(Arrays.asList(ignoredKeys));
                this.filter = Predicates.not(((Set)set)::contains);
            }
        }

        @Override
        public long hash(ComparisonContext context, DataComponentMap value) {
            return this.filter == null && value instanceof PatchedDataComponentMap ? (long)value.hashCode() : this.hashIgnoringKeys(value);
        }

        private long hashIgnoringKeys(DataComponentMap tag) {
            long i = 1L;
            for (TypedDataComponent entry : tag) {
                if (!this.filter.test(entry.type())) continue;
                i = i * 31L + (long)(Objects.hashCode(entry.type()) ^ Objects.hashCode(entry.value()));
            }
            return i;
        }
    }
}

