/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.fluid;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.Lists;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.fluid.FluidStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FluidSupportProviderImpl
extends ForwardingList<FluidSupportProvider.Provider>
implements FluidSupportProvider {
    private final List<FluidSupportProvider.Provider> providers = Lists.newCopyOnWriteArrayList();
    private final List<FluidSupportProvider.Provider> immutable = Collections.unmodifiableList(this.providers);

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REICommonPlugin plugin) {
        plugin.registerFluidSupport(this);
    }

    @Override
    public void startReload() {
        this.providers.clear();
    }

    @Override
    public void register(FluidSupportProvider.Provider provider) {
        this.providers.add(Objects.requireNonNull(provider, "Registered provider is null!"));
    }

    @Override
    public Optional<Stream<EntryStack<FluidStack>>> itemToFluids(EntryStack<? extends ItemStack> stack) {
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        for (FluidSupportProvider.Provider provider : this.providers) {
            CompoundEventResult<@Nullable Stream<EntryStack<FluidStack>>> resultHolder = Objects.requireNonNull(provider.itemToFluid(stack));
            if (!resultHolder.interruptsFurtherEvaluation()) continue;
            if (resultHolder.isTrue()) {
                return Optional.of((Stream)resultHolder.object());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    protected List<FluidSupportProvider.Provider> delegate() {
        return this.immutable;
    }
}

