/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.ItemRecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class InputSlotCrafter<T extends AbstractContainerMenu, C extends Container> {
    protected T container;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    protected ServerPlayer player;

    protected InputSlotCrafter(T container) {
        this.container = container;
    }

    public void fillInputSlots(ServerPlayer player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.getInventorySlots();
        this.inputStacks = this.getInputSlots();
        this.cleanInputs();
        ItemRecipeFinder recipeFinder = new ItemRecipeFinder();
        this.populateRecipeFinder(recipeFinder);
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        for (InputIngredient<ItemStack> itemStacks : this.getInputs()) {
            ingredients.add(itemStacks.get());
        }
        if (!recipeFinder.findRecipe(ingredients, 1, null)) {
            this.cleanInputs();
            this.markDirty();
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, ingredients, hasShift);
        this.markDirty();
    }

    protected abstract Iterable<SlotAccessor> getInputSlots();

    protected abstract Iterable<SlotAccessor> getInventorySlots();

    protected abstract List<InputIngredient<ItemStack>> getInputs();

    protected abstract void populateRecipeFinder(ItemRecipeFinder var1);

    protected abstract void markDirty();

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<ItemStack> recipeItems, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItems.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItems.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(ItemStack toBeTakenStack, SlotAccessor inputStack, int craftsAmount) {
        if (!toBeTakenStack.isEmpty()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, ItemStack toBeTakenStack) {
        ItemStack takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().copy()).isEmpty()) {
            if (takenStack.getCount() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(ItemStack.EMPTY);
            }
            takenStack.setCount(1);
            if (!slot.canPlace(takenStack)) {
                return;
            }
            if (slot.getItemStack().isEmpty()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().grow(1);
            }
        }
    }

    protected void fillInputSlots(ItemRecipeFinder recipeFinder, List<List<ItemStack>> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, Integer.MAX_VALUE, null);
        int amountToFill = hasShift ? recipeCrafts : 1;
        ArrayList recipeItems = new ArrayList();
        if (recipeFinder.findRecipe(ingredients, amountToFill, recipeItems::add)) {
            int finalCraftsAmount = amountToFill;
            for (ItemStack itemId : recipeItems) {
                finalCraftsAmount = Math.min(finalCraftsAmount, itemId.getMaxStackSize());
            }
            recipeItems.clear();
            if (recipeFinder.findRecipe(ingredients, finalCraftsAmount, recipeItems::add)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, recipeItems.iterator(), finalCraftsAmount);
            }
        }
    }

    protected abstract void cleanInputs();

    @Nullable
    public SlotAccessor takeInventoryStack(ItemStack itemStack) {
        boolean rejectedModification = false;
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            ItemStack itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.isEmpty() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.isDamaged() || itemStack1.isEnchanted() || itemStack1.has(DataComponents.CUSTOM_NAME)) continue;
            if (!inventoryStack.allowModification((Player)this.player)) {
                rejectedModification = true;
                continue;
            }
            return inventoryStack;
        }
        if (rejectedModification) {
            throw new IllegalStateException("Unable to take item from inventory due to slot not allowing modification! Item requested: " + String.valueOf(itemStack));
        }
        return null;
    }

    private static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

