/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.beacon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class DefaultBeaconBaseCategory
implements DisplayCategory<DefaultBeaconBaseDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultBeaconBaseDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.BEACON_BASE;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"category.rei.beacon_base");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.BEACON);
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultBeaconBaseDisplay display) {
        final Component name = this.getTitle();
        return new DisplayRenderer(this){

            @Override
            public int getHeight() {
                Objects.requireNonNull(Minecraft.getInstance().font);
                return 10 + 9;
            }

            @Override
            public void render(GuiGraphics graphics, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                graphics.drawString(Minecraft.getInstance().font, name, rectangle.x + 5, rectangle.y + 6, -1, false);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultBeaconBaseDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 8, bounds.y + 3)).entry(EntryStacks.of((ItemLike)Blocks.BEACON)));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2 - 1, bounds.y + 23, bounds.width + 2, bounds.height - 28);
        widgets.add(Widgets.createSlotBase(rectangle));
        widgets.add(new ScrollableSlotsWidget(rectangle, CollectionUtils.map(display.getEntries(), t -> Widgets.createSlot(new Point(0, 0)).disableBackground().entry((EntryStack<?>)t))));
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private Rectangle bounds;
        private List<Slot> widgets;
        private final ScrollingContainer scrolling = new ScrollingContainer(){

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                return Mth.ceil((float)((float)widgets.size() / 8.0f)) * 18;
            }
        };

        public ScrollableSlotsWidget(Rectangle bounds, List<Slot> widgets) {
            this.bounds = Objects.requireNonNull(bounds);
            this.widgets = Lists.newArrayList(widgets);
        }

        public boolean mouseScrolled(double double_1, double double_2, double amountX, double amountY) {
            if (this.containsMouse(double_1, double_2) && amountY != 0.0) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
            return false;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            try (CloseableScissors scissors = ScrollableSlotsWidget.scissor(graphics, innerBounds);){
                block10: for (int y = 0; y < Mth.ceil((float)((float)this.widgets.size() / 8.0f)); ++y) {
                    for (int x = 0; x < 8; ++x) {
                        int index = y * 8 + x;
                        if (this.widgets.size() <= index) continue block10;
                        Slot widget = this.widgets.get(index);
                        widget.getBounds().setLocation(this.bounds.x + 1 + x * 18, this.bounds.y + 1 + y * 18 - this.scrolling.scrollAmountInt());
                        widget.render(graphics, mouseX, mouseY, delta);
                    }
                }
            }
            scissors = ScrollableSlotsWidget.scissor(graphics, this.scrolling.getBounds());
            try {
                this.scrolling.renderScrollBar(graphics, -16777216, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
            finally {
                if (scissors != null) {
                    scissors.close();
                }
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }
    }
}

