/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import org.joml.Matrix4f;

public class ValueTagNodeWidget<S, T>
extends TagNodeWidget<S, T> {
    private final Rectangle bounds;
    private final List<Widget> widgets;
    private final WidgetWithBounds widget;
    private final List<? extends GuiEventListener> children;
    private final Rectangle overflowBounds;

    public ValueTagNodeWidget(TagNode<S> node, Function<Holder<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.overflowBounds = overflowBounds;
        HolderSet<S> holders = node.getValue();
        int width = Math.min(4, holders.size());
        int height = Math.max((int)Math.ceil((double)holders.size() * 1.0 / (double)width), 1);
        this.bounds = new Rectangle(0, 0, 16 * width + 12, 16 * height + 12);
        Panel background = Widgets.createRecipeBase(this.bounds.clone()).rendering((Predicate<Panel>)Predicates.alwaysTrue());
        Panel slotBackground = Widgets.createSlotBase(new Rectangle(5, 5, 16 * width + 2, 16 * height + 2));
        int i = 0;
        this.widgets = new ArrayList<Widget>();
        this.widgets.add(background);
        this.widgets.add(slotBackground);
        for (Holder holder : holders) {
            int x = i % width;
            int y = i / width;
            Slot slot = Widgets.createSlot(new Rectangle(x * 16 + 5, y * 16 + 5, 18, 18)).entry(mapper.apply(holder)).disableBackground();
            this.widgets.add(slot);
            ++i;
        }
        this.widget = Widgets.withTranslate(Widgets.concat(this.widgets), $ -> new Matrix4f().translate((float)this.getBounds().x, (float)this.getBounds().y, 0.0f));
        this.children = Collections.singletonList(this.widget);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Rectangle bounds = this.getBounds();
        if (this.overflowBounds.intersects(MatrixUtils.transform(graphics.pose().last().pose(), bounds))) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)bounds.x, (float)bounds.y, 0.0f);
            Point mouse = new Point(mouseX - bounds.x, mouseY - bounds.y);
            for (Widget widget : this.widgets) {
                if (widget instanceof WidgetWithBounds) {
                    WidgetWithBounds withBounds = (WidgetWithBounds)widget;
                    if (!this.overflowBounds.intersects(MatrixUtils.transform(graphics.pose().last().pose(), withBounds.getBounds()))) continue;
                }
                widget.render(graphics, mouse.x, mouse.y, delta);
            }
            graphics.pose().popPose();
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (GuiEventListener element : this.children()) {
            if (!element.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener element : this.children()) {
            if (!element.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }
}

