/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.google.common.base.Suppliers;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.gui.widgets.utils.PanelTextures;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.DisplayCompositeWidget;
import me.shedaniel.rei.impl.client.gui.widget.DisplayTooltipComponent;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.BomopofoInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.DoublePinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.JyutpingInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.PinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanManager;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.plugin.client.runtime.FilteredStacksVisibilityHandler;
import me.shedaniel.rei.plugin.client.runtime.InputMethodWatcher;
import me.shedaniel.rei.plugin.client.runtime.PluginStageExecutionWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchBarHighlightWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterPrepareWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterWatcher;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    private final FilteredStacksVisibilityHandler filteredStacksVisibilityHandler = new FilteredStacksVisibilityHandler();

    public DefaultClientRuntimePlugin() {
        PluginStageExecutionWatcher watcher = new PluginStageExecutionWatcher();
        for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
            instance.registerReloadable(watcher.reloadable(instance));
        }
        REIRuntimeImpl.getInstance().addHintProvider(watcher);
        REIRuntimeImpl.getInstance().addHintProvider(new SearchBarHighlightWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterPrepareWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new InputMethodWatcher());
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (((Boolean)ClientHelperImpl.getInstance().isAprilFools.get()).booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new Renderer(this){
                private final ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"textures/gui/kirb.png");

                @Override
                public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    graphics.innerBlit(RenderType::guiTextured, this.id, bounds.x, bounds.getMaxX(), bounds.y, bounds.getMaxY(), 0.0f, 0.0f, 1.0f, 0.0f, 1);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new Component[]{Component.literal((String)"Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
        ((EntryRegistryImpl)registry).listeners.add(new EntryRegistryListener(){

            @Override
            public void onReFilter(List<HNEntryStackWrapper> stacks) {
                DefaultClientRuntimePlugin.this.filteredStacksVisibilityHandler.reset();
            }
        });
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        this.filteredStacksVisibilityHandler.reset();
        registry.registerVisibilityPredicate(this.filteredStacksVisibilityHandler);
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(Screen.class, screen -> {
            FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null && widget.togglePanelButton.isVisible()) {
                return Collections.singletonList(widget.togglePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().children(), DraggableComponentProviderWidget.class::isInstance);
        }));
        registry.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().children(), DraggableComponentVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
        registry.register(DisplayFavoriteType.INSTANCE.id, DisplayFavoriteType.INSTANCE);
    }

    @Override
    public void registerInputMethods(InputMethodRegistry registry) {
        registry.add(DefaultInputMethod.ID, DefaultInputMethod.INSTANCE);
        UniHanManager manager = new UniHanManager(Platform.getConfigFolder().resolve("roughlyenoughitems/unihan.zip"));
        registry.add(ResourceLocation.parse((String)"rei:pinyin"), new PinyinInputMethod(manager));
        registry.add(ResourceLocation.parse((String)"rei:jyutping"), new JyutpingInputMethod(manager));
        registry.add(ResourceLocation.parse((String)"rei:bomopofo"), new BomopofoInputMethod(manager));
        registry.add(ResourceLocation.parse((String)"rei:double_pinyin"), new DoublePinyinInputMethod(manager));
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private final ResourceLocation id;

        private EntryStackFavoriteType(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> read(CompoundTag object) {
            try {
                return EntryStack.codec().parse((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)object.getCompound("data")).map(EntryStackFavoriteEntry::new).setLifecycle(Lifecycle.stable());
            }
            catch (Throwable throwable) {
                return DataResult.error(throwable::getMessage);
            }
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create EntryStackFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof EntryStack)) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from args expected EntryStack as the first argument!");
            }
            EntryStack stack = (EntryStack)object;
            if (!stack.supportSerialization()) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from an unserializable stack!");
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(EntryStackFavoriteEntry entry, CompoundTag tag) {
            tag.put("data", (Tag)EntryStack.codec().encodeStart((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), entry.stack).getOrThrow());
            return tag;
        }
    }

    private static enum DisplayFavoriteType implements FavoriteEntryType<DisplayFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.DISPLAY);

        private final String key = "data";
        private final ResourceLocation id;

        private DisplayFavoriteType(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public DataResult<DisplayFavoriteEntry> read(CompoundTag object) {
            try {
                if (object.contains("Data")) {
                    DataResult result = Display.codec().parse((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)object.getCompound("Data"));
                    return DataResult.success((Object)new DisplayFavoriteEntry((Display)result.getOrThrow(), UUID.fromString(object.getString("UUID"))), (Lifecycle)Lifecycle.stable());
                }
                return DataResult.success((Object)new DisplayFavoriteEntry(null, UUID.fromString(object.getString("UUID"))), (Lifecycle)Lifecycle.stable());
            }
            catch (Throwable throwable) {
                return DataResult.error(throwable::getMessage);
            }
        }

        @Override
        public DataResult<DisplayFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create DisplayFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Display)) {
                return DataResult.error(() -> "Creation of DisplayFavoriteEntry from args expected Display as the first argument!");
            }
            Display display = (Display)object;
            return DataResult.success((Object)new DisplayFavoriteEntry(display, UUID.randomUUID()), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(DisplayFavoriteEntry entry, CompoundTag tag) {
            boolean hasSerializer = entry.display.getSerializer() != null;
            tag.putString("CategoryID", entry.display.getCategoryIdentifier().toString());
            tag.putString("UUID", entry.uuid.toString());
            if (hasSerializer) {
                try {
                    DataResult displayTag = Display.codec().encodeStart((DynamicOps)BasicDisplay.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)entry.display);
                    tag.put("Data", (Tag)displayTag.getOrThrow());
                }
                catch (Exception e) {
                    InternalLogger.getInstance().warn("Failed to save display favorite entry", e);
                }
            }
            return tag;
        }
    }

    private static class DisplayFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final Supplier<DisplayTooltipComponent> tooltipComponent;
        private final Display display;
        private final UUID uuid;
        private final long hash;

        public DisplayFavoriteEntry(Display display, UUID uuid) {
            this.display = display;
            this.uuid = uuid;
            this.hash = uuid.hashCode();
            this.tooltipComponent = Suppliers.memoize(() -> new DisplayTooltipComponent(display));
        }

        @Override
        public UUID getUuid() {
            return this.uuid;
        }

        @Override
        public boolean isInvalid() {
            return this.display == null;
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            final Panel panel = Widgets.createRecipeBase(new Rectangle(0, 0, 18, 18)).texture(PanelTextures.LIGHTER);
            final Slot slot = Widgets.createSlot(new Rectangle()).disableBackground().disableHighlight().disableTooltips();
            for (EntryIngredient ingredient : this.display.getOutputEntries()) {
                slot.entries(ingredient);
            }
            return new Renderer(){

                @Override
                public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    graphics.pose().pushPose();
                    graphics.pose().translate((float)bounds.getX(), (float)bounds.getY(), 1.0f);
                    graphics.pose().scale((float)bounds.width / (float)panel.getBounds().getWidth(), (float)bounds.height / (float)panel.getBounds().getHeight(), 1.0f);
                    panel.render(graphics, mouseX, mouseY, delta);
                    graphics.pose().popPose();
                    if (bounds.width > 4 && bounds.height > 4) {
                        graphics.pose().pushPose();
                        graphics.pose().translate(0.0, 0.5, 0.0);
                        slot.getBounds().setBounds(bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4);
                        slot.render(graphics, mouseX, mouseY, delta);
                        graphics.pose().popPose();
                    }
                }

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    Tooltip tooltip = Tooltip.create(context.getPoint(), new Component[0]);
                    tooltip.add(tooltipComponent.get());
                    tooltip.add((Component)Component.translatable((String)"text.auto_craft.move_items.tooltip").withStyle(ChatFormatting.YELLOW));
                    return tooltip;
                }
            };
        }

        @Override
        public boolean doAction(int button) {
            Widgets.produceClickSound();
            if (!(Minecraft.getInstance().screen instanceof DisplayScreen) && Screen.hasControlDown()) {
                AutoCraftingEvaluator.evaluateAutoCrafting(true, Screen.hasShiftDown(), this.display, Collections::emptyList);
                return true;
            }
            ClientHelperImpl.getInstance().openDisplayViewingScreen(Map.of(CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier()).getCategory(), List.of(this.display)), null, List.of(), List.of());
            return true;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new DisplayFavoriteEntry(this.display, this.uuid);
        }

        @Override
        public ResourceLocation getType() {
            return DisplayFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof DisplayFavoriteEntry)) {
                return false;
            }
            DisplayFavoriteEntry that = (DisplayFavoriteEntry)other;
            return Objects.equals(this.uuid, that.uuid);
        }

        @Override
        @Nullable
        public DraggableComponent<?> asDraggableComponent(Slot slot) {
            CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier());
            DisplayCategory<?> category = configuration.getCategory();
            Rectangle displayBounds = new Rectangle(0, 0, category.getDisplayWidth(this.display), category.getDisplayHeight());
            List<Widget> widgets = configuration.getView(this.display).setupDisplay(this.display, displayBounds);
            DisplayCompositeWidget.DisplayDraggableComponent component = new DisplayCompositeWidget.DisplayDraggableComponent(Widgets.concat(CollectionUtils.filterToList(widgets, w -> !(w instanceof Panel))), this.display, slot.getInnerBounds(), displayBounds);
            component.onFavoritesRegion = true;
            return component;
        }
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hash;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hash = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(int button) {
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public ResourceLocation getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)other;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }
}

