/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Iterator;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.entry.filtering.FilteringContext;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResult;
import me.shedaniel.rei.api.client.entry.filtering.FilteringResultFactory;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class HideIngredientsFromTagsPlugin
implements REIClientPlugin {
    private static final ResourceLocation HIDDEN_TAG = ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hidden_from_recipe_viewers");

    static {
        FilteringRuleTypeRegistry.getInstance().register(ResourceLocation.fromNamespaceAndPath((String)"roughlyenoughitems", (String)"hidden_from_recipe_viewers"), HideTagsFilteringRuleType.INSTANCE);
        RoughlyEnoughItemsCoreClient.POST_UPDATE_TAGS.register(HideTagsFilteringRule.INSTANCE::markDirty);
    }

    private static enum HideTagsFilteringRuleType implements FilteringRuleType<HideTagsFilteringRule>
    {
        INSTANCE;


        @Override
        public CompoundTag saveTo(HideTagsFilteringRule rule, CompoundTag tag) {
            return tag;
        }

        @Override
        public HideTagsFilteringRule readFrom(CompoundTag tag) {
            return HideTagsFilteringRule.INSTANCE;
        }

        @Override
        public Component getTitle(HideTagsFilteringRule rule) {
            return Component.translatable((String)"rule.roughlyenoughitems.filtering.hide.tag");
        }

        @Override
        public Component getSubtitle(HideTagsFilteringRule rule) {
            return Component.translatable((String)"rule.roughlyenoughitems.filtering.hide.tag.subtitle");
        }

        @Override
        public HideTagsFilteringRule createNew() {
            return HideTagsFilteringRule.INSTANCE;
        }

        @Override
        public boolean isSingular() {
            return true;
        }
    }

    private static enum HideTagsFilteringRule implements FilteringRule<Cache>
    {
        INSTANCE;

        private Cache cache;

        @Override
        public FilteringRuleType<? extends FilteringRule<Cache>> getType() {
            return HideTagsFilteringRuleType.INSTANCE;
        }

        @Override
        public Cache prepareCache(boolean async) {
            try {
                EntryIngredient ingredient = EntryIngredient.builder().addAll(EntryIngredients.ofItemTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)HIDDEN_TAG))).addAll(EntryIngredients.ofItemTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)HIDDEN_TAG))).addAll(EntryIngredients.ofFluidTag((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)HIDDEN_TAG))).build();
                LongOpenHashSet hashes = new LongOpenHashSet();
                for (EntryStack stack : ingredient) {
                    hashes.add(EntryStacks.hashExact(stack));
                }
                this.cache = new Cache(ingredient, (LongSet)hashes);
                return this.cache;
            }
            catch (Throwable e) {
                InternalLogger.getInstance().warn("Failed to load hidden ingredients from tag, falling back to empty cache.", e);
                this.cache = null;
                return null;
            }
        }

        @Override
        public FilteringResult processFilteredStacks(FilteringContext context, FilteringResultFactory resultFactory, Cache cache, boolean async) {
            FilteringResult result = resultFactory.create();
            if (cache != null) {
                this.process(result, context.getShownStacks(), context.getShownExactHashes(), cache);
                this.process(result, context.getUnsetStacks(), context.getUnsetExactHashes(), cache);
            }
            return result;
        }

        private void process(FilteringResult result, Collection<EntryStack<?>> stacks, LongCollection hashes, Cache cache) {
            Iterator<EntryStack<?>> stackIterator = stacks.iterator();
            LongIterator hashIterator = hashes.iterator();
            while (stackIterator.hasNext()) {
                EntryStack<?> stack = stackIterator.next();
                long hash = hashIterator.nextLong();
                if (!cache.hashes().contains(hash)) continue;
                result.hide(stack);
            }
        }

        private void markDirty() {
            InternalLogger.getInstance().debug("Marking hidden ingredients from tag cache as dirty.");
            if (this.cache != null) {
                this.markDirty(this.cache.ingredient(), (LongCollection)this.cache.hashes());
            }
            try {
                VanillaEntryTypes.ITEM.getDefinition();
            }
            catch (NullPointerException ignored) {
                this.cache = null;
                return;
            }
            this.cache = this.prepareCache(false);
            if (this.cache != null) {
                this.markDirty(this.cache.ingredient(), (LongCollection)this.cache.hashes());
            }
            InternalLogger.getInstance().debug("Marked %d hidden ingredients from tag cache as dirty.", this.cache == null ? 0 : this.cache.hashes().size());
        }

        private record Cache(EntryIngredient ingredient, LongSet hashes) {
        }
    }
}

