/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.SmithingDisplay;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DefaultSmithingDisplay
extends BasicDisplay
implements SmithingDisplay {
    public static final DisplaySerializer<DefaultSmithingDisplay> SERIALIZER = DisplaySerializer.of(RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(BasicDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)SmithingDisplay.SmithingRecipeType.CODEC.optionalFieldOf("type").forGetter(d -> d.type), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation)).apply((Applicative)instance, DefaultSmithingDisplay::new)), StreamCodec.composite((StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getInputEntries, (StreamCodec)EntryIngredient.streamCodec().apply(ByteBufCodecs.list()), BasicDisplay::getOutputEntries, (StreamCodec)ByteBufCodecs.optional(SmithingDisplay.SmithingRecipeType.STREAM_CODEC), d -> d.type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), BasicDisplay::getDisplayLocation, DefaultSmithingDisplay::new));
    private final Optional<SmithingDisplay.SmithingRecipeType> type;

    @ApiStatus.Experimental
    public static DefaultSmithingDisplay ofTransforming(RecipeHolder<SmithingTransformRecipe> recipe) {
        return new DefaultSmithingDisplay(List.of(((SmithingTransformRecipe)recipe.value()).templateIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), ((SmithingTransformRecipe)recipe.value()).baseIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty()), ((SmithingTransformRecipe)recipe.value()).additionIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty())), List.of(EntryIngredients.of(((SmithingTransformRecipe)recipe.value()).result)), Optional.of(SmithingDisplay.SmithingRecipeType.TRANSFORM), Optional.of(recipe.id().location()));
    }

    public static List<DefaultSmithingDisplay> fromTrimming(RecipeHolder<SmithingTrimRecipe> recipe) {
        RegistryAccess registryAccess = BasicDisplay.registryAccess();
        ArrayList<DefaultSmithingDisplay> displays = new ArrayList<DefaultSmithingDisplay>();
        for (Holder templateItem : ((SmithingTrimRecipe)recipe.value()).templateIngredient().map(Ingredient::items).orElse(Stream.of(new Holder[0]))::iterator) {
            Holder.Reference trimPattern = DefaultSmithingDisplay.getPatternFromTemplate((HolderLookup.Provider)registryAccess, (Holder<Item>)templateItem).orElse(null);
            if (trimPattern == null) continue;
            for (Holder additionStack : ((SmithingTrimRecipe)recipe.value()).additionIngredient().map(Ingredient::items).orElse(Stream.of(new Holder[0]))::iterator) {
                Holder.Reference trimMaterial = DefaultSmithingDisplay.getMaterialFromIngredient((HolderLookup.Provider)registryAccess, (Holder<Item>)additionStack).orElse(null);
                if (trimMaterial == null) continue;
                EntryIngredient baseIngredient = ((SmithingTrimRecipe)recipe.value()).baseIngredient().map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty());
                EntryIngredient templateOutput = baseIngredient.isEmpty() ? EntryIngredient.empty() : DefaultSmithingDisplay.getTrimmingOutput(registryAccess, EntryStacks.ofItemHolder((Holder<? extends ItemLike>)templateItem), (EntryStack)baseIngredient.get(0), EntryStacks.ofItemHolder((Holder<? extends ItemLike>)additionStack));
                displays.add(new DefaultSmithingDisplay(List.of(EntryIngredients.ofItemHolder((Holder<? extends ItemLike>)templateItem), baseIngredient, EntryIngredients.ofItemHolder((Holder<? extends ItemLike>)additionStack)), List.of(templateOutput), Optional.of(SmithingDisplay.SmithingRecipeType.TRIM), Optional.of(recipe.id().location())));
            }
        }
        return displays;
    }

    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        this(inputs, outputs, Optional.empty(), location);
    }

    @ApiStatus.Experimental
    public DefaultSmithingDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<SmithingDisplay.SmithingRecipeType> type, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
        this.type = type;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.SMITHING;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    @Override
    @Nullable
    public SmithingDisplay.SmithingRecipeType type() {
        return this.type.orElse(null);
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static EntryIngredient getTrimmingOutput(RegistryAccess registryAccess, EntryStack<?> template, EntryStack<?> base, EntryStack<?> addition) {
        if (template.getType() != VanillaEntryTypes.ITEM || base.getType() != VanillaEntryTypes.ITEM || addition.getType() != VanillaEntryTypes.ITEM) {
            return EntryIngredient.empty();
        }
        ItemStack templateItem = (ItemStack)template.castValue();
        ItemStack baseItem = (ItemStack)base.castValue();
        ItemStack additionItem = (ItemStack)addition.castValue();
        Holder.Reference trimPattern = TrimPatterns.getFromTemplate((HolderLookup.Provider)registryAccess, (ItemStack)templateItem).orElse(null);
        if (trimPattern == null) {
            return EntryIngredient.empty();
        }
        Holder.Reference trimMaterial = TrimMaterials.getFromIngredient((HolderLookup.Provider)registryAccess, (ItemStack)additionItem).orElse(null);
        if (trimMaterial == null) {
            return EntryIngredient.empty();
        }
        ArmorTrim armorTrim = new ArmorTrim((Holder)trimMaterial, (Holder)trimPattern);
        ArmorTrim trim = (ArmorTrim)baseItem.get(DataComponents.TRIM);
        if (trim != null && trim.hasPatternAndMaterial((Holder)trimPattern, (Holder)trimMaterial)) {
            return EntryIngredient.empty();
        }
        ItemStack newItem = baseItem.copyWithCount(1);
        newItem.set(DataComponents.TRIM, (Object)armorTrim);
        return EntryIngredients.of(newItem);
    }

    private static Optional<Holder.Reference<TrimPattern>> getPatternFromTemplate(HolderLookup.Provider provider, Holder<Item> item) {
        return provider.lookupOrThrow(Registries.TRIM_PATTERN).listElements().filter(reference -> item == ((TrimPattern)reference.value()).templateItem()).findFirst();
    }

    private static Optional<Holder.Reference<TrimMaterial>> getMaterialFromIngredient(HolderLookup.Provider provider, Holder<Item> item) {
        return provider.lookupOrThrow(Registries.TRIM_MATERIAL).listElements().filter(reference -> item == ((TrimMaterial)reference.value()).ingredient()).findFirst();
    }
}

