/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.item.crafting;

import com.mojang.serialization.MapCodec;
import fuzs.arcanelanterns.init.ModRegistry;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class LanternMakingRecipe
extends ShapelessRecipe {
    public LanternMakingRecipe(ShapelessRecipe recipe) {
        this(recipe.group(), recipe.category(), recipe.assemble(CraftingInput.EMPTY, (HolderLookup.Provider)RegistryAccess.EMPTY), recipe.placementInfo().ingredients());
    }

    public LanternMakingRecipe(String group, CraftingBookCategory category, ItemStack result, List<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    public RecipeType<CraftingRecipe> getType() {
        return (RecipeType)ModRegistry.LANTERN_MAKING_RECIPE_TYPE.value();
    }

    public RecipeSerializer<ShapelessRecipe> getSerializer() {
        return (RecipeSerializer)ModRegistry.LANTERN_MAKING_RECIPE_SERIALIZER.value();
    }

    public boolean isSpecial() {
        return true;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.placementInfo().ingredients().stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.assemble(CraftingInput.EMPTY, (HolderLookup.Provider)RegistryAccess.EMPTY)), (SlotDisplay)new SlotDisplay.ItemSlotDisplay((Item)ModRegistry.LANTERN_MAKER_ITEM.value())));
    }

    public static class Serializer
    implements RecipeSerializer<LanternMakingRecipe> {
        public MapCodec<LanternMakingRecipe> codec() {
            return RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(LanternMakingRecipe::new, Function.identity());
        }

        public StreamCodec<RegistryFriendlyByteBuf, LanternMakingRecipe> streamCodec() {
            return RecipeSerializer.SHAPELESS_RECIPE.streamCodec().map(LanternMakingRecipe::new, Function.identity());
        }
    }
}

