/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.mixin.accessor.LivingEntityAccessor;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BrilliantLanternBlockEntity
extends LanternBlockEntity {
    public BrilliantLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BRILLIANT_LANTERN_BLOCK_ENTITY.value(), pos, state);
    }

    @Override
    public void serverTick() {
        ServerConfig.BrilliantLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).brilliantLantern;
        if (++this.ticks <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        List animals = this.getLevel().getEntitiesOfClass(Animal.class, new AABB((double)this.getBlockPos().getX() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 - (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 - (double)horizontalRange, (double)this.getBlockPos().getX() + 0.5 + (double)horizontalRange, (double)this.getBlockPos().getY() + 0.5 + (double)verticalRange, (double)this.getBlockPos().getZ() + 0.5 + (double)horizontalRange), BrilliantLanternBlockEntity::isValidAnimal);
        if (!animals.isEmpty()) {
            Animal animal = (Animal)animals.getFirst();
            BrilliantLanternBlockEntity.killWithoutLoot((ServerLevel)this.getLevel(), (LivingEntity)animal);
            animal.setLastHurtByPlayer(null);
            ((LivingEntityAccessor)animal).arcanelanterns$dropExperience((ServerLevel)this.getLevel(), null);
            animal.skipDropExperience();
        }
        this.ticks = 0;
    }

    private static boolean isValidAnimal(Animal animal) {
        TamableAnimal tamableAnimal;
        return animal.shouldDropExperience() && (!(animal instanceof TamableAnimal) || !(tamableAnimal = (TamableAnimal)animal).isTame()) && !((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).brilliantLantern.blacklist.contains((Object)animal.getType());
    }

    private static void killWithoutLoot(ServerLevel serverLevel, LivingEntity entity) {
        boolean doMobLoot = serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
        ((GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(false, serverLevel.getServer());
        entity.kill(serverLevel);
        ((GameRules.BooleanValue)serverLevel.getGameRules().getRule(GameRules.RULE_DOMOBLOOT)).set(doMobLoot, serverLevel.getServer());
    }
}

