/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class LoveLanternBlockEntity
extends LanternBlockEntity {
    public LoveLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.LOVE_LANTERN_BLOCK_ENTITY.value(), pos, state);
    }

    @Override
    public void serverTick() {
        ServerConfig.LoveLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).loveLantern;
        if (++this.ticks <= config.delay) {
            return;
        }
        int horizontalRange = config.horizontalRange;
        int verticalRange = config.verticalRange;
        List nearbyAnimals = this.getLevel().getEntitiesOfClass(Animal.class, new AABB((double)(this.getBlockPos().getX() - horizontalRange), (double)(this.getBlockPos().getY() - verticalRange), (double)(this.getBlockPos().getZ() - horizontalRange), (double)(this.getBlockPos().getX() + horizontalRange), (double)(this.getBlockPos().getY() + verticalRange), (double)(this.getBlockPos().getZ() + horizontalRange)));
        Collection<List<Animal>> animalsByType = nearbyAnimals.stream().collect(Collectors.groupingBy(Entity::getType)).values();
        for (List<Animal> animals : animalsByType) {
            if (animals.size() > config.maxAnimals) continue;
            animals.removeIf(animal -> animal.getAge() != 0 || !animal.canFallInLove());
            if (animals.size() < 2) continue;
            Collections.shuffle(animals);
            for (int i = 0; i < 2; ++i) {
                animals.get(i).setInLove(null);
            }
        }
        this.ticks = 0;
    }
}

