/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures;

import com.mistrx.prefabricated_structures.blueprints.BlueprintsConfig;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsData;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="prefabricated_structures")
public class PrefabricatedStructures {
    public static final String MODID = "prefabricated_structures";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"prefabricated_structures");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"prefabricated_structures");
    public static final List<DeferredItem<Item>> ALL_GENERATED_BLUEPRINTS = PrefabricatedStructures.generateAllBlueprints();
    public static final DeferredItem<Item> EMPTY_BLUEPRINT = ITEMS.registerSimpleItem("empty_blueprint", new Item.Properties().stacksTo(64).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prefabricated_structures", (String)"empty_blueprint"))));
    public static final DeferredItem<Item> BLUEPRINT = ITEMS.registerSimpleItem("blueprint", new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prefabricated_structures", (String)"blueprint"))));
    public static final DeferredItem<Item> BUILD_PLACER = ITEMS.registerSimpleItem("build_placer", new Item.Properties().stacksTo(1).rarity(Rarity.EPIC).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prefabricated_structures", (String)"build_placer"))));
    public static final DeferredItem<Item> CREATIVE_MODE_ICON = ITEMS.registerSimpleItem("creative_menu_icon_blueprint", new Item.Properties().stacksTo(1).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"prefabricated_structures", (String)"creative_menu_icon_blueprint"))));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.literal((String)"Blueprints")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((Item)CREATIVE_MODE_ICON.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        for (DeferredItem<Item> allGeneratedBlueprint : ALL_GENERATED_BLUEPRINTS) {
            output.accept((ItemLike)allGeneratedBlueprint.get());
        }
        output.accept((ItemLike)EMPTY_BLUEPRINT.get());
        output.accept((ItemLike)BLUEPRINT.get());
        output.accept((ItemLike)BUILD_PLACER.get());
    }).build());

    private static List<DeferredItem<Item>> generateAllBlueprints() {
        ArrayList<DeferredItem<Item>> blueprintItems = new ArrayList<DeferredItem<Item>>();
        for (String blueprintData : BlueprintsData.blueprintsData) {
            String[] array = blueprintData.split(":");
            DeferredItem blueprint = ITEMS.registerSimpleItem(array[0], new Item.Properties().stacksTo(64).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)array[0]))));
            blueprintItems.add((DeferredItem<Item>)blueprint);
        }
        return blueprintItems;
    }

    public PrefabricatedStructures(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BlueprintsConfig.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="prefabricated_structures", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

