/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BindBuildCommand {
    public static HashMap<String, String> loadedBuildNames = new HashMap();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"bindbuild").executes(source -> BindBuildCommand.run((CommandSourceStack)source.getSource())));
    }

    public static Integer run(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemStack.getItem().equals(PrefabricatedStructures.BUILD_PLACER.get())) {
            source.sendFailure((Component)Component.translatable((String)"commands.bindbuild.wrong-item"));
            return 0;
        }
        String status = Firebase.getSelectedBuildingID();
        if (!Objects.equals(status, "success")) {
            MutableComponent component = Component.literal((String)"Learn More");
            Style componentStyle = Style.EMPTY;
            componentStyle = componentStyle.applyFormat(ChatFormatting.LIGHT_PURPLE);
            componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.youtube.com/watch?v=3p3VZ0WffQI"));
            componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Watch a short YouTube video to get started")));
            component.setStyle(componentStyle);
            source.sendFailure((Component)Component.translatable((String)"commands.bindbuild.error", (Object[])new Object[]{component}));
        }
        BuildPlacerHandler.setTag((Player)player, "buildpaste.bound-build-id", Variables.buildID);
        String name = "Unnamed";
        if (!loadedBuildNames.containsKey(Variables.buildID)) {
            String buildName = Firebase.getBuildName(Variables.buildID);
            if (buildName != null) {
                name = buildName;
            }
        } else {
            name = loadedBuildNames.get(Variables.buildID);
        }
        loadedBuildNames.put(Variables.buildID, name);
        player.getItemInHand(InteractionHand.MAIN_HAND).set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
        String finalName = name;
        source.sendSuccess(() -> Component.translatable((String)"commands.bindbuild.success", (Object[])new Object[]{finalName}), false);
        return 1;
    }
}

