/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3d;

public final class PasteCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"paste").requires(source -> source.hasPermission(4))).executes(source -> PasteCommand.pasteCommand((CommandSourceStack)source.getSource(), null, null))).then(Commands.argument((String)"first argument", (ArgumentType)StringArgumentType.string()).executes(source -> PasteCommand.pasteCommand((CommandSourceStack)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"first argument"), null)))).then(Commands.argument((String)"first argument", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"second argument", (ArgumentType)StringArgumentType.string()).executes(source -> PasteCommand.pasteCommand((CommandSourceStack)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"first argument"), StringArgumentType.getString((CommandContext)source, (String)"second argument"))))));
    }

    public static int pasteCommand(CommandSourceStack source, String firstarg, String secondarg) throws CommandSyntaxException {
        String[] args = new String[]{firstarg, secondarg};
        PrefabricatedStructures.LOGGER.info("Paste Command executed");
        String direction = null;
        try {
            float yRot = source.getPlayerOrException().getViewYRot(1.0f);
            direction = Functions.getLookDirection(yRot);
            Functions.setPlayerVariables((Player)source.getPlayerOrException());
            if (Functions.sendInvalidUUIDMessage((Player)source.getPlayerOrException()).booleanValue()) {
                source.sendSuccess(() -> Component.translatable((String)"util.doesnt-have-valid-uuid"), true);
            }
        }
        catch (CommandSyntaxException e) {
            PrefabricatedStructures.LOGGER.info("Error in try catch at pasteCommand");
            e.printStackTrace();
        }
        PrefabricatedStructures.LOGGER.info("Direction: " + direction);
        String response = Functions.setBuilding(new Vector3d(Math.floor(source.getPosition().x), Math.floor(source.getPosition().y), Math.floor(source.getPosition().z)), direction, args, true);
        PrefabricatedStructures.LOGGER.info("getBuild Response: " + response);
        if (response != null) {
            if (response.equals("success")) {
                Integer blocksCount = (int)(Firebase.size.x * Firebase.size.y * Firebase.size.z);
                String firstPos = Functions.PosToString(Variables.lastFirstPos);
                String secondPos = Functions.PosToString(Variables.lastSecondPos);
                MutableComponent modify = Component.literal((String)"[Quick Actions]");
                Style publishStyle = Style.EMPTY;
                publishStyle = publishStyle.applyFormat(ChatFormatting.GOLD);
                publishStyle = publishStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/_openpastemenu " + firstPos + " " + secondPos + " " + Variables.buildID));
                publishStyle = publishStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Change Blocks, Materials, Undo or turn your build into a real-life 3D printed replica").withStyle(ChatFormatting.GOLD)));
                modify.setStyle(publishStyle);
                MutableComponent incompatibleBlocksComponent = Component.literal((String)(Variables.incompatibleBlocksAmount != 0 && Variables.incompatibleBlocksExampleBlocksReplacedArray.size() != 0 ? " (" + Variables.incompatibleBlocksAmount + " incompatible blocks replaced with similar ones)" : ""));
                Object exampleBlockString = "";
                int blockAmountInExampleBlocks = 0;
                for (int i = 0; i < Variables.incompatibleBlocksExampleBlocksReplacedArray.size(); ++i) {
                    String exampleBlock = Variables.incompatibleBlocksExampleBlocksReplacedArray.get(i);
                    String[] exampleBlockSplit = exampleBlock.split(",");
                    if (exampleBlockSplit.length != 3) continue;
                    try {
                        blockAmountInExampleBlocks += Integer.parseInt(exampleBlockSplit[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    exampleBlockString = (String)exampleBlockString + String.valueOf(ChatFormatting.WHITE) + exampleBlockSplit[2] + "x " + String.valueOf(ChatFormatting.RED) + exampleBlockSplit[0] + String.valueOf(ChatFormatting.WHITE) + " -> " + String.valueOf(ChatFormatting.GREEN) + exampleBlockSplit[1] + (i != Variables.incompatibleBlocksExampleBlocksReplacedArray.size() - 1 ? "\n" : "");
                    if (i != Variables.incompatibleBlocksExampleBlocksReplacedArray.size() - 1 || blockAmountInExampleBlocks >= Variables.incompatibleBlocksAmount) continue;
                    exampleBlockString = (String)exampleBlockString + "\n" + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.ITALIC) + "And " + (Variables.incompatibleBlocksAmount - blockAmountInExampleBlocks) + " more blocks...";
                }
                Style incompatibleBlocksStyle = Style.EMPTY.withItalic(Boolean.valueOf(true));
                incompatibleBlocksStyle = incompatibleBlocksStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)exampleBlockString)));
                incompatibleBlocksComponent.setStyle(incompatibleBlocksStyle);
                source.sendSuccess(() -> Component.translatable((String)"commands.paste.success", (Object[])new Object[]{String.valueOf(blocksCount), incompatibleBlocksComponent, modify}), true);
            } else if (response.equals("error")) {
                String url = Variables.url;
                MutableComponent buildpastecomponent = Component.literal((String)"Buildpaste.net");
                Style componentStyle = Style.EMPTY;
                componentStyle = componentStyle.applyFormat(ChatFormatting.GREEN);
                componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://buildpaste.net/category?&player=" + source.getPlayerOrException().getDisplayName().getString()));
                componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open buildpaste.net and create an account").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN))));
                buildpastecomponent.setStyle(componentStyle);
                source.sendSuccess(() -> Component.translatable((String)"account.required", (Object[])new Object[]{buildpastecomponent}), true);
            } else if (response.equals("error-404")) {
                source.sendFailure((Component)Component.translatable((String)"commands.paste.error-404"));
            } else if (response.equals("random-error")) {
                source.sendFailure((Component)Component.translatable((String)"commands.paste.random-error"));
            }
        }
        return 1;
    }
}

