/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.commands;

import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mistrx.prefabricated_structures.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.joml.Vector3d;

public class PasteForBuildPlacerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"_pastebuildplacer").executes(source -> PasteForBuildPlacerCommand.run((CommandSourceStack)source.getSource())));
    }

    public static int run(CommandSourceStack source) throws CommandSyntaxException {
        String pastemodifier = Variables.suggestion;
        if (BuildPlacerHandler.currentDoPlaceAir) {
            pastemodifier = "nopastemodifier";
        }
        Functions.pasteCurrentBuilding(new Vector3d((double)RenderHandler.startPreviewPosition.getX(), (double)RenderHandler.startPreviewPosition.getY(), (double)RenderHandler.startPreviewPosition.getZ()), RenderHandler.renderDirection, pastemodifier, false, false);
        ServerPlayer player = source.getPlayer();
        if (BuildPlacerHandler.currentDoRandomRotation) {
            RenderHandler.renderDirection = Functions.getLookDirection((float)(Math.random() * 360.0));
            BuildPlacerHandler.currentDirectionIndex = Arrays.asList(BuildPlacerHandler.directionsArray).indexOf(RenderHandler.renderDirection);
        }
        if (BuildPlacerHandler.currentDoSendSuccessMessage) {
            Integer blocksCount = (int)(Firebase.size.x * Firebase.size.y * Firebase.size.z);
            String firstPos = Functions.PosToString(Variables.lastFirstPos);
            String secondPos = Functions.PosToString(Variables.lastSecondPos);
            MutableComponent modify = Component.literal((String)"[Quick Actions]");
            Style publishStyle = Style.EMPTY;
            publishStyle = publishStyle.applyFormat(ChatFormatting.GOLD);
            publishStyle = publishStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/_openpastemenu " + firstPos + " " + secondPos + " " + Variables.buildID));
            publishStyle = publishStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Change Blocks, Materials, Undo or turn your build into a real-life 3D printed replica").withStyle(ChatFormatting.GOLD)));
            modify.setStyle(publishStyle);
            MutableComponent incompatibleBlocksComponent = Component.literal((String)(Variables.incompatibleBlocksAmount != 0 && Variables.incompatibleBlocksExampleBlocksReplacedArray.size() != 0 ? " (" + Variables.incompatibleBlocksAmount + " incompatible blocks replaced with similar ones)" : ""));
            Object exampleBlockString = "";
            int blockAmountInExampleBlocks = 0;
            for (int i = 0; i < Variables.incompatibleBlocksExampleBlocksReplacedArray.size(); ++i) {
                String exampleBlock = Variables.incompatibleBlocksExampleBlocksReplacedArray.get(i);
                String[] exampleBlockSplit = exampleBlock.split(",");
                if (exampleBlockSplit.length != 3) continue;
                try {
                    blockAmountInExampleBlocks += Integer.parseInt(exampleBlockSplit[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                exampleBlockString = (String)exampleBlockString + String.valueOf(ChatFormatting.WHITE) + exampleBlockSplit[2] + "x " + String.valueOf(ChatFormatting.RED) + exampleBlockSplit[0] + String.valueOf(ChatFormatting.WHITE) + " -> " + String.valueOf(ChatFormatting.GREEN) + exampleBlockSplit[1] + (i != Variables.incompatibleBlocksExampleBlocksReplacedArray.size() - 1 ? "\n" : "");
                if (i != Variables.incompatibleBlocksExampleBlocksReplacedArray.size() - 1 || blockAmountInExampleBlocks >= Variables.incompatibleBlocksAmount) continue;
                exampleBlockString = (String)exampleBlockString + "\n" + String.valueOf(ChatFormatting.WHITE) + String.valueOf(ChatFormatting.ITALIC) + "And " + (Variables.incompatibleBlocksAmount - blockAmountInExampleBlocks) + " more blocks...";
            }
            Style incompatibleBlocksStyle = Style.EMPTY.withItalic(Boolean.valueOf(true));
            incompatibleBlocksStyle = incompatibleBlocksStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)exampleBlockString)));
            incompatibleBlocksComponent.setStyle(incompatibleBlocksStyle);
            source.sendSuccess(() -> Component.translatable((String)"commands.paste.success", (Object[])new Object[]{String.valueOf(blocksCount), incompatibleBlocksComponent, modify}), true);
        }
        if (RenderHandler.isUsingPreviewCommand) {
            RenderHandler.stopRendering();
        }
        return 1;
    }
}

