/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.events;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.blueprints.BlueprintsFunctions;
import com.mistrx.prefabricated_structures.gui.PasteMenuHandler;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.rendering.Render;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Functions;
import com.mistrx.prefabricated_structures.util.Raycast;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="prefabricated_structures", bus=EventBusSubscriber.Bus.GAME)
public class GameEvents {
    private static boolean hasJoinedWorldOnce = false;
    private static boolean clearCarriedItemNextTime = false;
    private static int lastSelectedItemSlot = 0;
    private static boolean hasBuildPlacerSelected = false;
    private static Integer tickCount = 0;

    @SubscribeEvent
    public static void WorldEnterEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        PrefabricatedStructures.LOGGER.info("PlayerLoggedInEvent");
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        Functions.setPlayerVariables(player);
        if (!player.isCreative()) {
            return;
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        if (RenderHandler.shouldRenderStructure && (RenderHandler.hasRaycastHitSomething || RenderHandler.isUsingPreviewCommand) && Minecraft.getInstance().player != null) {
            Render.renderBlocks(event);
        }
    }

    @SubscribeEvent
    public static void ContainerEvent(PlayerContainerEvent event) {
        if (BlueprintsFunctions.hasBuildpasteLoaded().booleanValue()) {
            return;
        }
        if (!PasteMenuHandler.minecartIsBeingOpened) {
            if (PasteMenuHandler.minecart == null) {
                return;
            }
            PasteMenuHandler.isOpened = false;
            PasteMenuHandler.currentMenu = "";
            PasteMenuHandler.minecart.clearContent();
            Level level = event.getEntity().getCommandSenderWorld();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PasteMenuHandler.minecart.kill(serverLevel);
            }
            PrefabricatedStructures.LOGGER.info("Close Container");
            return;
        }
        PasteMenuHandler.minecartIsBeingOpened = false;
        PasteMenuHandler.isOpened = true;
        PrefabricatedStructures.LOGGER.info("Open Container");
    }

    @SubscribeEvent
    public static void TickEvent(PlayerTickEvent.Pre event) throws IOException {
        if (BlueprintsFunctions.hasBuildpasteLoaded().booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (tickCount % 20 * 3 == 0 && PasteMenuHandler.minecart != null && !PasteMenuHandler.clickDetected) {
            PrefabricatedStructures.LOGGER.info("  -  looking for item change");
            PasteMenuHandler.currentMinecartInventory.clear();
            int containerSize = PasteMenuHandler.minecart.getContainerSize();
            for (int i = 0; i < containerSize; ++i) {
                PasteMenuHandler.currentMinecartInventory.add(PasteMenuHandler.minecart.getItem(i));
            }
            if (!PasteMenuHandler.currentMinecartInventory.equals(PasteMenuHandler.previousMinecartInventory) && PasteMenuHandler.previousMinecartInventory.size() > 0) {
                PasteMenuHandler.clickDetected = true;
                int changedItemIndex = -1;
                int size = PasteMenuHandler.currentMinecartInventory.size();
                for (int i = 0; i < size; ++i) {
                    if (PasteMenuHandler.currentMinecartInventory.get(i).equals(PasteMenuHandler.previousMinecartInventory.get(i))) continue;
                    changedItemIndex = i;
                    break;
                }
                PasteMenuHandler.handleClick(player, PasteMenuHandler.lastMinecartContents.get(changedItemIndex));
                clearCarriedItemNextTime = true;
            }
        }
        if (clearCarriedItemNextTime && !player.getCommandSenderWorld().isClientSide()) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PrefabricatedStructures.LOGGER.info("Clearing the carried item");
            serverPlayer.inventoryMenu.setCarried(ItemStack.EMPTY);
            serverPlayer.containerMenu.setCarried(ItemStack.EMPTY);
            serverPlayer.containerMenu.broadcastChanges();
            serverPlayer.inventoryMenu.slotsChanged((Container)player.getInventory());
            clearCarriedItemNextTime = false;
            if (PasteMenuHandler.closeContainerNextTime) {
                player.closeContainer();
                PasteMenuHandler.closeContainerNextTime = false;
            }
        }
        if (player.level().isClientSide) {
            int currentItemSlot = player.getInventory().selected;
            if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == PrefabricatedStructures.BUILD_PLACER.get() && lastSelectedItemSlot == currentItemSlot) {
                if (Objects.equals(BuildPlacerHandler.status, "build-loaded")) {
                    BlockHitResult hitResult = Raycast.getHitBlock(player.getCommandSenderWorld(), player, ClipContext.Fluid.NONE, 1000.0);
                    if (hitResult.getType().equals((Object)HitResult.Type.MISS)) {
                        RenderHandler.hasRaycastHitSomething = false;
                    } else {
                        RenderHandler.hasRaycastHitSomething = true;
                        RenderHandler.calculateStartPreviewPositionWithRaycastPosition(hitResult.getBlockPos(), player);
                    }
                }
                if (!hasBuildPlacerSelected) {
                    BuildPlacerHandler.status = "selected";
                    hasBuildPlacerSelected = true;
                    RenderHandler.isUsingPreviewCommand = false;
                }
                player.displayClientMessage((Component)Component.translatable((String)("item.buildpaste.build_placer." + BuildPlacerHandler.status)).setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)), true);
            } else if (hasBuildPlacerSelected) {
                RenderHandler.stopRendering();
                BuildPlacerHandler.status = "";
                hasBuildPlacerSelected = false;
            }
            lastSelectedItemSlot = currentItemSlot;
        }
        Integer n = tickCount;
        tickCount = tickCount + 1;
    }
}

