/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.items.build_placer;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mistrx.prefabricated_structures.util.Variables;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class BuildPlacerHandler {
    public static String status = "";
    public static boolean currentDoRandomRotation = false;
    public static boolean currentDoPlaceOneBlockBelow = false;
    public static boolean currentDoPlaceAir = false;
    public static boolean currentDoSendSuccessMessage = false;
    public static String[] directionsArray = new String[]{"north", "east", "south", "west"};
    public static int currentDirectionIndex = 0;

    public static void handleLeftClick(final Player player) {
        if (Objects.equals(status, "selected")) {
            String boundBuildId = BuildPlacerHandler.getTag(player, "buildpaste.bound-build-id");
            PrefabricatedStructures.LOGGER.info("BoundBuildID: " + boundBuildId);
            if (boundBuildId == null) {
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        status = "loading";
                        String oldBuildID = Variables.buildID;
                        String status = Firebase.getSelectedBuildingID();
                        if (status.equals("error")) {
                            BuildPlacerHandler.status = "not-connected";
                            MutableComponent buildpastecomponent = Component.literal((String)"Buildpaste.net");
                            Style componentStyle = Style.EMPTY;
                            componentStyle = componentStyle.applyFormat(ChatFormatting.GREEN);
                            componentStyle = componentStyle.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://buildpaste.net/category?&player=" + player.getDisplayName().getString()));
                            componentStyle = componentStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open buildpaste.net and create an account").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN))));
                            buildpastecomponent.setStyle(componentStyle);
                            Variables.player.displayClientMessage((Component)Component.translatable((String)"account.required", (Object[])new Object[]{buildpastecomponent}), false);
                            return;
                        }
                        String newBuildID = Variables.buildID;
                        if (!Objects.equals(oldBuildID, newBuildID) || Firebase.blockIDs == null) {
                            String getBuildResult = Firebase.getBuilding(Variables.buildID, false, null, null, null);
                            if (getBuildResult.equals("error-404")) {
                                BuildPlacerHandler.status = "error-404";
                                return;
                            }
                            if (getBuildResult.equals("error")) {
                                BuildPlacerHandler.status = "error";
                                return;
                            }
                        }
                        BuildPlacerHandler.status = "build-loaded";
                        RenderHandler.prepareRenderBlocks(player);
                    }
                }, 1L);
            } else {
                Variables.buildID = boundBuildId;
                final String finalBoundBuildId = boundBuildId;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        status = "loading";
                        String getBuildResult = Firebase.getBuilding(finalBoundBuildId, false, null, null, null);
                        if (getBuildResult.equals("error-404")) {
                            status = "error-404";
                            return;
                        }
                        if (getBuildResult.equals("error")) {
                            status = "error";
                            return;
                        }
                        status = "build-loaded";
                        RenderHandler.prepareRenderBlocks(player);
                    }
                }, 1L);
            }
        } else if (Objects.equals(status, "build-loaded")) {
            Minecraft.getInstance().player.connection.sendUnsignedCommand("_pastebuildplacer");
        }
    }

    public static void handleRightClick(Player player) {
        if (Objects.equals(status, "selected")) {
            PrefabricatedStructures.LOGGER.info("opening on right click");
            Minecraft.getInstance().player.connection.sendUnsignedCommand("_openbuildplacermenu");
        } else if (Objects.equals(status, "build-loaded")) {
            String currentDirection = directionsArray[currentDirectionIndex];
            System.out.println("Current direction: " + currentDirection);
            currentDirectionIndex = (currentDirectionIndex + 1) % directionsArray.length;
            RenderHandler.renderDirection = directionsArray[currentDirectionIndex];
        }
    }

    public static void loadBuildPlacerVariables(Player player) {
        BuildPlacerHandler.setCurrentDoRandomRotationWithString(player);
        BuildPlacerHandler.setCurrentDoPlaceOneBlockBelow(player);
        BuildPlacerHandler.setCurrentDoPlaceAir(player);
        BuildPlacerHandler.setCurrentDoSendSuccessMessage(player);
    }

    public static void setCurrentDoRandomRotationWithString(Player player) {
        String randomRotationTagValue = BuildPlacerHandler.getTag(player, "buildpaste.do-random-rotate");
        currentDoRandomRotation = Objects.equals(randomRotationTagValue, "true");
    }

    public static void setCurrentDoPlaceOneBlockBelow(Player player) {
        String tagValue = BuildPlacerHandler.getTag(player, "buildpaste.do-place-one-block-below");
        currentDoPlaceOneBlockBelow = Objects.equals(tagValue, "true");
    }

    public static void setCurrentDoPlaceAir(Player player) {
        String tagValue = BuildPlacerHandler.getTag(player, "buildpaste.do-place-air");
        currentDoPlaceAir = Objects.equals(tagValue, "true");
    }

    public static void setCurrentDoSendSuccessMessage(Player player) {
        String tagValue = BuildPlacerHandler.getTag(player, "buildpaste.do-send-success-message");
        currentDoSendSuccessMessage = Objects.equals(tagValue, "true");
    }

    public static void setTag(Player player, String tag, String value) {
        CompoundTag compoundTag = new CompoundTag();
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (itemStack.getItem() != PrefabricatedStructures.BUILD_PLACER.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"commands.error", (Object[])new Object[]{"BuildPlacerHandler/No-BuildPlacer-in-hand"}), false);
            return;
        }
        if (itemStack.get(DataComponents.CUSTOM_DATA) != null) {
            compoundTag = ((CustomData)itemStack.get(DataComponents.CUSTOM_DATA)).copyTag();
        }
        if (compoundTag.contains(tag)) {
            if (Objects.equals(value, "true")) {
                compoundTag.putString(tag, "false");
            } else {
                compoundTag.remove(tag);
            }
        } else {
            compoundTag.putString(tag, value);
        }
        CustomData.set((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, (CompoundTag)compoundTag);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
    }

    public static String getTag(Player player, String tag) {
        if (!player.getItemInHand(InteractionHand.MAIN_HAND).getItem().equals(PrefabricatedStructures.BUILD_PLACER.get()) || player.getItemInHand(InteractionHand.MAIN_HAND).get(DataComponents.CUSTOM_DATA) == null) {
            return null;
        }
        CompoundTag compoundTag = ((CustomData)player.getItemInHand(InteractionHand.MAIN_HAND).get(DataComponents.CUSTOM_DATA)).copyTag();
        if (!compoundTag.contains(tag)) {
            return null;
        }
        return compoundTag.getString(tag);
    }
}

