/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.rendering;

import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.rendering.RenderBlock;
import com.mistrx.prefabricated_structures.rendering.RenderHandler;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL11;

public class Render {
    private static VertexBuffer vertexBuffer;
    public static boolean requestedRefresh;
    private static BufferBuilder buffer;
    private static String latestDirection;
    private static BlockPos latestStartPosition;

    public static void renderBlocks(RenderLevelStageEvent event) {
        if (!latestStartPosition.equals((Object)RenderHandler.startPreviewPosition) || !Objects.equals(latestDirection, RenderHandler.renderDirection)) {
            latestStartPosition = RenderHandler.startPreviewPosition;
            latestDirection = RenderHandler.renderDirection;
            requestedRefresh = true;
        }
        if (vertexBuffer == null || requestedRefresh) {
            requestedRefresh = false;
            buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
            vertexBuffer = new VertexBuffer(BufferUsage.STATIC_WRITE);
            float opacity = 1.0f;
            Vector3d size = Firebase.size;
            String direction = RenderHandler.renderDirection;
            BlockPos startPreviewPosition = RenderHandler.startPreviewPosition;
            int i = 0;
            if (Firebase.uploadDirection.equals("north") || Firebase.uploadDirection.equals("south")) {
                if (Objects.equals(direction, "north")) {
                    for (double x = size.x; x > 0.0; x -= 1.0) {
                        for (double y = 0.0; y < size.y; y += 1.0) {
                            for (double z = size.z; z > 0.0; z -= 1.0) {
                                BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + x), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + z - size.z));
                                Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                                ++i;
                            }
                        }
                    }
                } else if (Objects.equals(direction, "south")) {
                    for (double x = 0.0; x < size.x; x += 1.0) {
                        for (double y = 0.0; y < size.y; y += 1.0) {
                            for (double z = 0.0; z < size.z; z += 1.0) {
                                BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + x - size.x), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + z));
                                Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                                ++i;
                            }
                        }
                    }
                } else if (Objects.equals(direction, "east")) {
                    for (double x = size.x; x > 0.0; x -= 1.0) {
                        for (double y = 0.0; y < size.y; y += 1.0) {
                            for (double z = 0.0; z < size.z; z += 1.0) {
                                BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + z), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + x));
                                Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                                ++i;
                            }
                        }
                    }
                } else if (Objects.equals(direction, "west")) {
                    for (double x = 0.0; x < size.x; x += 1.0) {
                        for (double y = 0.0; y < size.y; y += 1.0) {
                            for (double z = size.z; z > 0.0; z -= 1.0) {
                                BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + z - size.z), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + x - size.x));
                                Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                                ++i;
                            }
                        }
                    }
                }
            } else if (direction.equals("north")) {
                for (double x = size.x; x > 0.0; x -= 1.0) {
                    for (double y = 0.0; y < size.y; y += 1.0) {
                        for (double z = size.z; z > 0.0; z -= 1.0) {
                            BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + z), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + x - size.x));
                            Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                            ++i;
                        }
                    }
                }
            } else if (direction.equals("south")) {
                for (double x = 0.0; x < size.x; x += 1.0) {
                    for (double y = 0.0; y < size.y; y += 1.0) {
                        for (double z = 0.0; z < size.z; z += 1.0) {
                            BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + z - size.z), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + x));
                            Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                            ++i;
                        }
                    }
                }
            } else if (direction.equals("east")) {
                for (double x = 0.0; x < size.x; x += 1.0) {
                    for (double y = 0.0; y < size.y; y += 1.0) {
                        for (double z = size.z; z > 0.0; z -= 1.0) {
                            BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + x), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + z));
                            Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                            ++i;
                        }
                    }
                }
            } else if (direction.equals("west")) {
                for (double x = size.x; x > 0.0; x -= 1.0) {
                    for (double y = 0.0; y < size.y; y += 1.0) {
                        for (double z = 0.0; z < size.z; z += 1.0) {
                            BlockPos currentPos = new BlockPos((int)((double)startPreviewPosition.getX() + x - size.x), (int)((double)startPreviewPosition.getY() + y), (int)((double)startPreviewPosition.getZ() + z - size.z));
                            Render.addBlock(currentPos, RenderHandler.renderBlocks.get(i));
                            ++i;
                        }
                    }
                }
            }
            vertexBuffer.bind();
            if (Render.isEmpty(buffer)) {
                return;
            }
            vertexBuffer.upload(buffer.buildOrThrow());
            VertexBuffer.unbind();
        }
        if (vertexBuffer != null && !Render.isEmpty(buffer)) {
            Vec3 view = Minecraft.getInstance().getEntityRenderDispatcher().camera.getPosition();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2848);
            RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
            PoseStack matrix = event.getPoseStack();
            matrix.pushPose();
            matrix.mulPose(event.getModelViewMatrix());
            matrix.translate(-view.x, -view.y, -view.z);
            vertexBuffer.bind();
            vertexBuffer.drawWithShader(matrix.last().pose(), new Matrix4f((Matrix4fc)event.getProjectionMatrix()), RenderSystem.getShader());
            VertexBuffer.unbind();
            matrix.popPose();
            GL11.glDisable((int)2848);
        }
    }

    private static void addBlock(BlockPos pos, RenderBlock renderBlock) {
        if (renderBlock == null) {
            return;
        }
        int color = renderBlock.getColor();
        float size = 1.0f;
        float x = pos.getX();
        float y = pos.getY();
        float z = pos.getZ();
        buffer.addVertex(x, y + 1.0f, z).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x, y + 1.0f, z).setColor(color);
        buffer.addVertex(x + 1.0f, y, z).setColor(color);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(color);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(color);
        buffer.addVertex(x, y, z + 1.0f).setColor(color);
        buffer.addVertex(x, y, z + 1.0f).setColor(color);
        buffer.addVertex(x, y, z).setColor(color);
        buffer.addVertex(x, y, z).setColor(color);
        buffer.addVertex(x + 1.0f, y, z).setColor(color);
        buffer.addVertex(x + 1.0f, y, z + 1.0f).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x + 1.0f, y, z).setColor(color);
        buffer.addVertex(x + 1.0f, y + 1.0f, z).setColor(color);
        buffer.addVertex(x, y, z + 1.0f).setColor(color);
        buffer.addVertex(x, y + 1.0f, z + 1.0f).setColor(color);
        buffer.addVertex(x, y, z).setColor(color);
        buffer.addVertex(x, y + 1.0f, z).setColor(color);
    }

    public static boolean isEmpty(BufferBuilder bufferBuilder) {
        try {
            Field vertexCountField = BufferBuilder.class.getDeclaredField("vertices");
            vertexCountField.setAccessible(true);
            int vertexCount = (Integer)vertexCountField.get(bufferBuilder);
            return vertexCount == 0;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return true;
        }
    }

    static {
        requestedRefresh = false;
        latestDirection = "north";
        latestStartPosition = new BlockPos(0, 0, 0);
    }
}

