/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.prefabricated_structures.rendering;

import com.mistrx.prefabricated_structures.PrefabricatedStructures;
import com.mistrx.prefabricated_structures.firebase.Firebase;
import com.mistrx.prefabricated_structures.items.build_placer.BuildPlacerHandler;
import com.mistrx.prefabricated_structures.rendering.RenderBlock;
import com.mistrx.prefabricated_structures.util.AllBlocksArray;
import com.mistrx.prefabricated_structures.util.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;

public class RenderHandler {
    public static BlockPos startPreviewPosition = new BlockPos(0, 0, 0);
    public static String renderDirection = "north";
    private static String previewedBuildID = "";
    public static boolean shouldRenderStructure = false;
    public static boolean hasRaycastHitSomething = false;
    public static boolean isUsingPreviewCommand = false;
    public static List<RenderBlock> renderBlocks = new ArrayList<RenderBlock>();

    public static void prepareRenderBlocks(Player player) {
        BuildPlacerHandler.loadBuildPlacerVariables(player);
        PrefabricatedStructures.LOGGER.info("Current do random rotation: " + BuildPlacerHandler.currentDoRandomRotation);
        if (!isUsingPreviewCommand && BuildPlacerHandler.currentDoRandomRotation) {
            PrefabricatedStructures.LOGGER.info("Random Direction");
            renderDirection = Functions.getLookDirection((float)(Math.random() * 360.0));
        } else {
            float playerLookDirection = player.getViewYRot(1.0f);
            PrefabricatedStructures.LOGGER.info("Player Look Direction: " + playerLookDirection);
            renderDirection = Functions.getLookDirection(playerLookDirection);
        }
        PrefabricatedStructures.LOGGER.info("Look Direction: " + renderDirection);
        BuildPlacerHandler.currentDirectionIndex = Arrays.asList(BuildPlacerHandler.directionsArray).indexOf(renderDirection);
        for (int i = 0; i < Firebase.blockIDs.size(); ++i) {
            int id;
            try {
                id = Math.round(Float.parseFloat(Firebase.blockIDs.get(i).toString()));
            }
            catch (Exception e) {
                renderBlocks.add(null);
                continue;
            }
            ResourceLocation resourceLocation = ResourceLocation.parse((String)("minecraft:" + AllBlocksArray.blocksArray[id]));
            Block foundBlock = (Block)BuiltInRegistries.BLOCK.getValue(resourceLocation);
            if (foundBlock == Blocks.AIR || foundBlock.defaultBlockState().getRenderShape() != RenderShape.MODEL) {
                renderBlocks.add(null);
                continue;
            }
            int color = foundBlock.defaultMapColor().calculateARGBColor(MapColor.Brightness.HIGH);
            RenderBlock renderBlock = new RenderBlock(color);
            renderBlocks.add(renderBlock);
        }
        shouldRenderStructure = true;
    }

    public static void stopRendering() {
        isUsingPreviewCommand = false;
        shouldRenderStructure = false;
        renderBlocks.clear();
    }

    public static void calculateStartPreviewPositionWithRaycastPosition(BlockPos rayHit, Player player) {
        Vec3 startPos;
        if (Firebase.size == null) {
            return;
        }
        if (Firebase.uploadDirection.equals("north") || Firebase.uploadDirection.equals("south")) {
            switch (renderDirection) {
                case "east": {
                    startPos = new Vec3((double)rayHit.getX() - Firebase.size.z / 2.0 + 1.0, (double)rayHit.getY(), (double)rayHit.getZ() - Firebase.size.x / 2.0);
                    break;
                }
                case "south": {
                    startPos = new Vec3((double)rayHit.getX() + Firebase.size.x / 2.0 + 1.0, (double)rayHit.getY(), (double)rayHit.getZ() - Firebase.size.z / 2.0 + 1.0);
                    break;
                }
                case "west": {
                    startPos = new Vec3((double)rayHit.getX() + Firebase.size.z / 2.0, (double)rayHit.getY(), (double)rayHit.getZ() + Firebase.size.x / 2.0 + 1.0);
                    break;
                }
                default: {
                    startPos = new Vec3((double)rayHit.getX() - Firebase.size.x / 2.0, (double)rayHit.getY(), (double)rayHit.getZ() + Firebase.size.z / 2.0);
                    break;
                }
            }
        } else {
            switch (renderDirection) {
                case "east": {
                    startPos = new Vec3((double)rayHit.getX() - Firebase.size.x / 2.0 + 1.0, (double)rayHit.getY(), (double)rayHit.getZ() - Firebase.size.z / 2.0);
                    break;
                }
                case "south": {
                    startPos = new Vec3((double)rayHit.getX() + Firebase.size.z / 2.0 + 1.0, (double)rayHit.getY(), (double)rayHit.getZ() - Firebase.size.x / 2.0 + 1.0);
                    break;
                }
                case "west": {
                    startPos = new Vec3((double)rayHit.getX() + Firebase.size.x / 2.0, (double)rayHit.getY(), (double)rayHit.getZ() + Firebase.size.z / 2.0 + 1.0);
                    break;
                }
                default: {
                    startPos = new Vec3((double)rayHit.getX() - Firebase.size.z / 2.0, (double)rayHit.getY(), (double)rayHit.getZ() + Firebase.size.x / 2.0);
                }
            }
        }
        int yPos = (int)Math.round(startPos.y);
        if (!BuildPlacerHandler.currentDoPlaceOneBlockBelow) {
            ++yPos;
        }
        startPreviewPosition = new BlockPos((int)Math.floor(startPos.x), yPos, (int)Math.floor(startPos.z));
    }
}

