/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.blockentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.UncolossalChest;
import org.cyclops.colossalchests.inventory.container.ContainerUncolossalChest;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityUncolossalChest
extends CyclopsBlockEntity
implements MenuProvider,
LidBlockEntity {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_OPEN);
        }

        protected void onClose(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityUncolossalChest.playSound(level, pos, blockState, SoundEvents.CHEST_CLOSE);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityUncolossalChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ContainerUncolossalChest)) {
                return false;
            }
            Container container = ((ContainerUncolossalChest)player.containerMenu).getContainerInventory();
            return container == BlockEntityUncolossalChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    private Component customName = null;
    private final SimpleInventory inventory = new SimpleInventory(5, 64){

        public void startOpen(Player entityPlayer) {
            if (!entityPlayer.isSpectator()) {
                super.startOpen(entityPlayer);
                BlockEntityUncolossalChest.this.startOpen(entityPlayer);
            }
        }

        public void stopOpen(Player entityPlayer) {
            if (!entityPlayer.isSpectator()) {
                super.stopOpen(entityPlayer);
                BlockEntityUncolossalChest.this.stopOpen(entityPlayer);
            }
        }
    };

    public BlockEntityUncolossalChest(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_UNCOLOSSAL_CHEST.value(), blockPos, blockState);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.inventory.read(provider, tag.getCompound("inventory"));
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)provider);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        CompoundTag subTag = new CompoundTag();
        this.inventory.write(provider, subTag);
        tag.put("inventory", (Tag)subTag);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.playSound((Player)null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.2f + 1.15f);
    }

    public boolean triggerEvent(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.shouldBeOpen(value > 0);
            return true;
        }
        return super.triggerEvent(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.getBlock();
        level.blockEvent(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityUncolossalChest blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float value) {
        return this.chestLidController.getOpenness(value);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component getDisplayName() {
        return this.hasCustomName() ? this.customName : Component.translatable((String)"general.colossalchests.uncolossalchest");
    }

    public Direction getRotation() {
        if (this.getLevel() == null) {
            return Direction.SOUTH;
        }
        BlockState blockState = this.getLevel().getBlockState(this.getBlockPos());
        if (blockState.getBlock() != RegistryEntries.BLOCK_UNCOLOSSAL_CHEST.value()) {
            return Direction.NORTH;
        }
        return (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, UncolossalChest.FACING, (Comparable)Direction.NORTH);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerUncolossalChest(id, playerInventory, (Container)this.getInventory());
    }
}

