/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.advancement.criterion.ChestFormedTrigger;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityInterface;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IInventoryHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class ItemUpgradeTool
extends Item {
    private final boolean upgrade;

    public ItemUpgradeTool(Item.Properties properties, boolean upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.getBlock() instanceof IBlockChestMaterial && ((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (Property)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(((IBlockChestMaterial)blockState.getBlock()).getMaterial(), (LevelReader)context.getLevel(), context.getClickedPos());
            BlockEntityColossalChest tile = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)context.getLevel(), tileLocation, BlockEntityColossalChest.class).orElse(null);
            ChestMaterial newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (context.getLevel().isClientSide()) {
                    return InteractionResult.PASS;
                }
                ColossalChest.addPlayerChatError(context.getPlayer(), (Component)Component.translatable((String)"multiblock.colossalchests.error.upgradeLimit"));
                return InteractionResult.FAIL;
            }
            Component firstError = null;
            do {
                Component error;
                if ((error = this.attemptTransform(context.getLevel(), context.getClickedPos(), context.getPlayer(), tile, newType, tile.getMaterial(), context.getHand())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return context.getLevel().isClientSide() ? InteractionResult.PASS : InteractionResult.SUCCESS;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(context.getPlayer(), firstError);
            return context.getLevel().isClientSide() ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return context.getLevel().isClientSide() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    protected Component attemptTransform(Level world, BlockPos pos, Player player, BlockEntityColossalChest tile, ChestMaterial newType, ChestMaterial currentType, InteractionHand hand) {
        Vec3i size = tile.getSize();
        ChestMaterial validMaterial = null;
        Wrapper requiredCoresCount = new Wrapper((Object)0);
        Wrapper requiredInterfacesCount = new Wrapper((Object)0);
        Wrapper requiredWallsCount = new Wrapper((Object)0);
        for (ChestMaterial material : ChestMaterial.VALUES) {
            DetectionResult result = material.getChestDetector().detect((LevelReader)world, pos, null, (location, blockState) -> {
                if (blockState.getBlock() instanceof ColossalChest) {
                    requiredCoresCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                } else if (blockState.getBlock() instanceof Interface) {
                    requiredInterfacesCount.set((Object)((Integer)requiredInterfacesCount.get() + 1));
                } else if (blockState.getBlock() instanceof ChestWall) {
                    requiredWallsCount.set((Object)((Integer)requiredWallsCount.get() + 1));
                }
                return null;
            }, false);
            if (result.getError() != null) continue;
            validMaterial = material;
            break;
        }
        ItemStack requiredCores = new ItemStack((ItemLike)newType.getBlockCore(), ((Integer)requiredCoresCount.get()).intValue());
        ItemStack requiredInterfaces = new ItemStack((ItemLike)newType.getBlockInterface(), ((Integer)requiredInterfacesCount.get()).intValue());
        ItemStack requiredWalls = new ItemStack((ItemLike)newType.getBlockWall(), ((Integer)requiredWallsCount.get()).intValue());
        if (validMaterial == null) {
            return Component.translatable((String)"multiblock.colossalchests.error.unexpected");
        }
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return Component.translatable((String)"multiblock.colossalchests.error.upgrade", (Object[])new Object[]{requiredCores.getCount(), requiredInterfaces.getCount(), requiredWalls.getCount(), Component.translatable((String)newType.getUnlocalizedName())});
        }
        this.consumeItems(player, requiredCores.copy(), false);
        this.consumeItems(player, requiredInterfaces.copy(), false);
        this.consumeItems(player, requiredWalls.copy(), false);
        if (!world.isClientSide) {
            tile.setSize(Vec3i.ZERO);
            SimpleInventory oldInventory = tile.getLastValidInventory();
            Direction oldRotation = tile.getRotation();
            Vec3 oldRenderOffset = tile.getRenderOffset();
            ArrayList oldInterfaceLocations = Lists.newArrayList(tile.getInterfaceLocations());
            Wrapper coreLocation = new Wrapper(null);
            ArrayList interfaceLocations = Lists.newArrayList();
            validMaterial.getChestDetector().detect((LevelReader)world, pos, null, (location, blockState) -> {
                BlockState blockStateNew = null;
                if (blockState.getBlock() instanceof ColossalChest) {
                    coreLocation.set((Object)location);
                    blockStateNew = newType.getBlockCore().defaultBlockState();
                } else if (blockState.getBlock() instanceof Interface) {
                    blockStateNew = newType.getBlockInterface().defaultBlockState();
                    interfaceLocations.add(location);
                } else if (blockState.getBlock() instanceof ChestWall) {
                    blockStateNew = newType.getBlockWall().defaultBlockState();
                }
                world.setBlock(location, (BlockState)blockStateNew.setValue((Property)ColossalChest.ENABLED, (Comparable)((Boolean)blockState.getValue((Property)ColossalChest.ENABLED))), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
                if (blockState.getBlock() instanceof ColossalChest || blockState.getBlock() instanceof Interface) {
                    tile.addInterface((Vec3i)location);
                }
                return null;
            }, false);
            BlockEntityColossalChest tileNew = (BlockEntityColossalChest)((Object)IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, (BlockPos)coreLocation.get(), BlockEntityColossalChest.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest core location during upgrading.")));
            tileNew.setLastValidInventory(oldInventory);
            tileNew.setMaterial(newType);
            tileNew.setRotation(oldRotation);
            tileNew.setRenderOffset(oldRenderOffset);
            for (Vec3i oldInterfaceLocation : oldInterfaceLocations) {
                tileNew.addInterface(oldInterfaceLocation);
            }
            tileNew.setSize(size);
            for (BlockPos interfaceLocation : interfaceLocations) {
                BlockEntityInterface tileInterface = (BlockEntityInterface)((Object)IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, interfaceLocation, BlockEntityInterface.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest interface location during upgrading.")));
                tileInterface.setCorePosition((Vec3i)coreLocation.get());
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((ChestFormedTrigger)((Object)RegistryEntries.TRIGGER_CHEST_FORMED.value())).test(serverPlayer, newType, size.getX() + 1);
            }
        }
        ItemStack returnedCores = new ItemStack((ItemLike)currentType.getBlockCore(), requiredCores.getCount());
        ItemStack returnedInterfaces = new ItemStack((ItemLike)currentType.getBlockInterface(), requiredInterfaces.getCount());
        ItemStack returnedWalls = new ItemStack((ItemLike)currentType.getBlockWall(), requiredWalls.getCount());
        IInventoryHelpers inventoryHelpers = IModHelpers.get().getInventoryHelpers();
        inventoryHelpers.tryReAddToStack(player, ItemStack.EMPTY, returnedCores, hand);
        inventoryHelpers.tryReAddToStack(player, ItemStack.EMPTY, returnedInterfaces, hand);
        inventoryHelpers.tryReAddToStack(player, ItemStack.EMPTY, returnedWalls, hand);
        return null;
    }

    protected boolean consumeItems(Player player, ItemStack consumeStack, boolean simulate) {
        if (player.isCreative()) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.getCount();
            validItems = Math.min(consumeStack.getCount(), validItems);
            if (simulate) continue;
            stack.shrink(validItems - previousValidItems);
            it.replace(stack.getCount() == 0 ? ItemStack.EMPTY : stack);
        }
        return validItems == consumeStack.getCount();
    }

    protected ChestMaterial transformType(ItemStack itemStack, ChestMaterial type) {
        if (this.upgrade && type.ordinal() < ChestMaterial.VALUES.size() - 1) {
            return ChestMaterial.VALUES.get(type.ordinal() + 1);
        }
        if (!this.upgrade && type.ordinal() > 0) {
            return ChestMaterial.VALUES.get(type.ordinal() - 1);
        }
        return null;
    }
}

