/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.inventory.SortProvider;
import fuzs.completionistsindex.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedMap;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public enum IndexGroup implements SortProvider<IndexGroup>
{
    CREATIVE{

        @Override
        SequencedMap<Component, List<ItemStack>> getGroups(List<ItemStack> allItems) {
            LinkedHashMap<Component, List<ItemStack>> groups = new LinkedHashMap<Component, List<ItemStack>>();
            for (CreativeModeTab creativeModeTab : BuiltInRegistries.CREATIVE_MODE_TAB.stream().toList()) {
                List<ItemStack> items;
                if (creativeModeTab.getType() != CreativeModeTab.Type.CATEGORY || ((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).hiddenCreativeTabs.contains((Object)creativeModeTab) || (items = 1.getDisplayItems(creativeModeTab)).isEmpty()) continue;
                groups.put(creativeModeTab.getDisplayName(), items);
            }
            return groups;
        }
    }
    ,
    MODS{

        @Override
        SequencedMap<Component, List<ItemStack>> getGroups(List<ItemStack> items) {
            return items.stream().collect(Collectors.groupingBy(itemStack -> {
                String s = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace();
                return Component.literal((String)2.getModDisplayName(s));
            }, LinkedHashMap::new, Collectors.toList()));
        }
    };

    private static final IndexGroup[] VALUES;
    private final Component component = Component.translatable((String)("completionistsindex.gui.index.group." + this.name().toLowerCase(Locale.ROOT)));

    @Override
    public IndexGroup cycle() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Comparator<IndexViewScreen.IndexViewPage.Entry> getComparator() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (arg_0, arg_1) -> ((Ordering)Ordering.allEqual()).compare(arg_0, arg_1);
            case 1 -> Comparator.comparing(IndexViewScreen.IndexViewPage.Entry::toComparableKey);
        };
    }

    abstract SequencedMap<Component, List<ItemStack>> getGroups(List<ItemStack> var1);

    public final Map<Component, List<ItemStack>> getGroups() {
        List<ItemStack> items = IndexGroup.getDisplayItems(CreativeModeTabs.searchTab());
        SequencedMap<Component, List<ItemStack>> groups = this.getGroups(items);
        if (groups.size() > 1) {
            groups.putFirst((Component)Component.translatable((String)"gui.all"), items != null ? items : IndexGroup.getDisplayItems(CreativeModeTabs.searchTab()));
        }
        return ImmutableMap.copyOf(groups);
    }

    static List<ItemStack> getDisplayItems(CreativeModeTab creativeModeTab) {
        return creativeModeTab.getDisplayItems().stream().map(ItemStack::getItem).distinct().filter(((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class))::filterItems).map(ItemStack::new).toList();
    }

    static String getModDisplayName(String modId) {
        return ModLoaderEnvironment.INSTANCE.getModContainer(modId).map(ModContainer::getDisplayName).orElse(IndexGroup.createDisplayNameFromModId(modId));
    }

    static String createDisplayNameFromModId(String modId) {
        String[] parts;
        StringJoiner stringJoiner = new StringJoiner(" ");
        for (String part : parts = modId.split("_")) {
            if (part.isEmpty()) continue;
            stringJoiner.add(Character.toUpperCase(part.charAt(0)) + part.substring(1).toLowerCase(Locale.ROOT));
        }
        return stringJoiner.toString();
    }

    static {
        VALUES = IndexGroup.values();
    }
}

